package org.openqa.selenium.devtools.v129.autofill;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * Defines commands and events for Autofill.
 */
@Beta()
public class Autofill {

    /**
     * Trigger autofill on a form identified by the fieldId.
     * If the field and related form cannot be autofilled, returns an error.
     */
    public static Command<Void> trigger(org.openqa.selenium.devtools.v129.dom.model.BackendNodeId fieldId, java.util.Optional<org.openqa.selenium.devtools.v129.page.model.FrameId> frameId, org.openqa.selenium.devtools.v129.autofill.model.CreditCard card) {
        java.util.Objects.requireNonNull(fieldId, "fieldId is required");
        java.util.Objects.requireNonNull(card, "card is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("fieldId", fieldId);
        frameId.ifPresent(p -> params.put("frameId", p));
        params.put("card", card);
        return new Command<>("Autofill.trigger", Map.copyOf(params));
    }

    /**
     * Set addresses so that developers can verify their forms implementation.
     */
    public static Command<Void> setAddresses(java.util.List<org.openqa.selenium.devtools.v129.autofill.model.Address> addresses) {
        java.util.Objects.requireNonNull(addresses, "addresses is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("addresses", addresses);
        return new Command<>("Autofill.setAddresses", Map.copyOf(params));
    }

    /**
     * Disables autofill domain notifications.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Autofill.disable", Map.copyOf(params));
    }

    /**
     * Enables autofill domain notifications.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Autofill.enable", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v129.autofill.model.AddressFormFilled> addressFormFilled() {
        return new Event<>("Autofill.addressFormFilled", input -> input.read(org.openqa.selenium.devtools.v129.autofill.model.AddressFormFilled.class));
    }
}
