package org.openqa.selenium.devtools.v129.pwa;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain allows interacting with the browser to control PWAs.
 */
@Beta()
public class PWA {

    public static class GetOsAppStateResponse {

        private final java.lang.Integer badgeCount;

        private final java.util.List<org.openqa.selenium.devtools.v129.pwa.model.FileHandler> fileHandlers;

        public GetOsAppStateResponse(java.lang.Integer badgeCount, java.util.List<org.openqa.selenium.devtools.v129.pwa.model.FileHandler> fileHandlers) {
            this.badgeCount = java.util.Objects.requireNonNull(badgeCount, "badgeCount is required");
            this.fileHandlers = java.util.Objects.requireNonNull(fileHandlers, "fileHandlers is required");
        }

        public java.lang.Integer getBadgeCount() {
            return badgeCount;
        }

        public java.util.List<org.openqa.selenium.devtools.v129.pwa.model.FileHandler> getFileHandlers() {
            return fileHandlers;
        }

        private static GetOsAppStateResponse fromJson(JsonInput input) {
            java.lang.Integer badgeCount = 0;
            java.util.List<org.openqa.selenium.devtools.v129.pwa.model.FileHandler> fileHandlers = null;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "badgeCount":
                        badgeCount = input.nextNumber().intValue();
                        break;
                    case "fileHandlers":
                        fileHandlers = input.readArray(org.openqa.selenium.devtools.v129.pwa.model.FileHandler.class);
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetOsAppStateResponse(badgeCount, fileHandlers);
        }
    }

    /**
     * Returns the following OS state for the given manifest id.
     */
    public static Command<org.openqa.selenium.devtools.v129.pwa.PWA.GetOsAppStateResponse> getOsAppState(java.lang.String manifestId) {
        java.util.Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("manifestId", manifestId);
        return new Command<>("PWA.getOsAppState", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v129.pwa.PWA.GetOsAppStateResponse.class));
    }

    /**
     * Installs the given manifest identity, optionally using the given install_url
     * or IWA bundle location.
     *
     * TODO(crbug.com/337872319) Support IWA to meet the following specific
     * requirement.
     * IWA-specific install description: If the manifest_id is isolated-app://,
     * install_url_or_bundle_url is required, and can be either an http(s) URL or
     * file:// URL pointing to a signed web bundle (.swbn). The .swbn file's
     * signing key must correspond to manifest_id. If Chrome is not in IWA dev
     * mode, the installation will fail, regardless of the state of the allowlist.
     */
    public static Command<Void> install(java.lang.String manifestId, java.util.Optional<java.lang.String> installUrlOrBundleUrl) {
        java.util.Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("manifestId", manifestId);
        installUrlOrBundleUrl.ifPresent(p -> params.put("installUrlOrBundleUrl", p));
        return new Command<>("PWA.install", Map.copyOf(params));
    }

    /**
     * Uninstalls the given manifest_id and closes any opened app windows.
     */
    public static Command<Void> uninstall(java.lang.String manifestId) {
        java.util.Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("manifestId", manifestId);
        return new Command<>("PWA.uninstall", Map.copyOf(params));
    }

    /**
     * Launches the installed web app, or an url in the same web app instead of the
     * default start url if it is provided. Returns a page Target.TargetID which
     * can be used to attach to via Target.attachToTarget or similar APIs.
     */
    public static Command<org.openqa.selenium.devtools.v129.target.model.TargetID> launch(java.lang.String manifestId, java.util.Optional<java.lang.String> url) {
        java.util.Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("manifestId", manifestId);
        url.ifPresent(p -> params.put("url", p));
        return new Command<>("PWA.launch", Map.copyOf(params), ConverterFunctions.map("targetId", org.openqa.selenium.devtools.v129.target.model.TargetID.class));
    }

    /**
     * Opens one or more local files from an installed web app identified by its
     * manifestId. The web app needs to have file handlers registered to process
     * the files. The API returns one or more page Target.TargetIDs which can be
     * used to attach to via Target.attachToTarget or similar APIs.
     * If some files in the parameters cannot be handled by the web app, they will
     * be ignored. If none of the files can be handled, this API returns an error.
     * If no files are provided as the parameter, this API also returns an error.
     *
     * According to the definition of the file handlers in the manifest file, one
     * Target.TargetID may represent a page handling one or more files. The order
     * of the returned Target.TargetIDs is not guaranteed.
     *
     * TODO(crbug.com/339454034): Check the existences of the input files.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v129.target.model.TargetID>> launchFilesInApp(java.lang.String manifestId, java.util.List<java.lang.String> files) {
        java.util.Objects.requireNonNull(manifestId, "manifestId is required");
        java.util.Objects.requireNonNull(files, "files is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("manifestId", manifestId);
        params.put("files", files);
        return new Command<>("PWA.launchFilesInApp", Map.copyOf(params), ConverterFunctions.map("targetIds", input -> input.readArray(org.openqa.selenium.devtools.v129.target.model.TargetID.class)));
    }

    /**
     * Opens the current page in its web app identified by the manifest id, needs
     * to be called on a page target. This function returns immediately without
     * waiting for the app to finish loading.
     */
    public static Command<Void> openCurrentPageInApp(java.lang.String manifestId) {
        java.util.Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("manifestId", manifestId);
        return new Command<>("PWA.openCurrentPageInApp", Map.copyOf(params));
    }

    /**
     * Changes user settings of the web app identified by its manifestId. If the
     * app was not installed, this command returns an error. Unset parameters will
     * be ignored; unrecognized values will cause an error.
     *
     * Unlike the ones defined in the manifest files of the web apps, these
     * settings are provided by the browser and controlled by the users, they
     * impact the way the browser handling the web apps.
     *
     * See the comment of each parameter.
     */
    public static Command<Void> changeAppUserSettings(java.lang.String manifestId, java.util.Optional<java.lang.Boolean> linkCapturing, java.util.Optional<org.openqa.selenium.devtools.v129.pwa.model.DisplayMode> displayMode) {
        java.util.Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("manifestId", manifestId);
        linkCapturing.ifPresent(p -> params.put("linkCapturing", p));
        displayMode.ifPresent(p -> params.put("displayMode", p));
        return new Command<>("PWA.changeAppUserSettings", Map.copyOf(params));
    }
}
