package org.openqa.selenium.devtools.v130.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Details for issues about documents in Quirks Mode
 * or Limited Quirks Mode that affects page layouting.
 */
public class QuirksModeIssueDetails {

    private final java.lang.Boolean isLimitedQuirksMode;

    private final org.openqa.selenium.devtools.v130.dom.model.BackendNodeId documentNodeId;

    private final java.lang.String url;

    private final org.openqa.selenium.devtools.v130.page.model.FrameId frameId;

    private final org.openqa.selenium.devtools.v130.network.model.LoaderId loaderId;

    public QuirksModeIssueDetails(java.lang.Boolean isLimitedQuirksMode, org.openqa.selenium.devtools.v130.dom.model.BackendNodeId documentNodeId, java.lang.String url, org.openqa.selenium.devtools.v130.page.model.FrameId frameId, org.openqa.selenium.devtools.v130.network.model.LoaderId loaderId) {
        this.isLimitedQuirksMode = java.util.Objects.requireNonNull(isLimitedQuirksMode, "isLimitedQuirksMode is required");
        this.documentNodeId = java.util.Objects.requireNonNull(documentNodeId, "documentNodeId is required");
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.loaderId = java.util.Objects.requireNonNull(loaderId, "loaderId is required");
    }

    /**
     * If false, it means the document's mode is "quirks"
     * instead of "limited-quirks".
     */
    public java.lang.Boolean getIsLimitedQuirksMode() {
        return isLimitedQuirksMode;
    }

    public org.openqa.selenium.devtools.v130.dom.model.BackendNodeId getDocumentNodeId() {
        return documentNodeId;
    }

    public java.lang.String getUrl() {
        return url;
    }

    public org.openqa.selenium.devtools.v130.page.model.FrameId getFrameId() {
        return frameId;
    }

    public org.openqa.selenium.devtools.v130.network.model.LoaderId getLoaderId() {
        return loaderId;
    }

    private static QuirksModeIssueDetails fromJson(JsonInput input) {
        java.lang.Boolean isLimitedQuirksMode = false;
        org.openqa.selenium.devtools.v130.dom.model.BackendNodeId documentNodeId = null;
        java.lang.String url = null;
        org.openqa.selenium.devtools.v130.page.model.FrameId frameId = null;
        org.openqa.selenium.devtools.v130.network.model.LoaderId loaderId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "isLimitedQuirksMode":
                    isLimitedQuirksMode = input.nextBoolean();
                    break;
                case "documentNodeId":
                    documentNodeId = input.read(org.openqa.selenium.devtools.v130.dom.model.BackendNodeId.class);
                    break;
                case "url":
                    url = input.nextString();
                    break;
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v130.page.model.FrameId.class);
                    break;
                case "loaderId":
                    loaderId = input.read(org.openqa.selenium.devtools.v130.network.model.LoaderId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new QuirksModeIssueDetails(isLimitedQuirksMode, documentNodeId, url, frameId, loaderId);
    }
}
