package org.openqa.selenium.devtools.v130.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Identifies the bottom-most script which caused the frame to be labelled
 * as an ad.
 */
@org.openqa.selenium.Beta()
public class AdScriptId {

    private final org.openqa.selenium.devtools.v130.runtime.model.ScriptId scriptId;

    private final org.openqa.selenium.devtools.v130.runtime.model.UniqueDebuggerId debuggerId;

    public AdScriptId(org.openqa.selenium.devtools.v130.runtime.model.ScriptId scriptId, org.openqa.selenium.devtools.v130.runtime.model.UniqueDebuggerId debuggerId) {
        this.scriptId = java.util.Objects.requireNonNull(scriptId, "scriptId is required");
        this.debuggerId = java.util.Objects.requireNonNull(debuggerId, "debuggerId is required");
    }

    /**
     * Script Id of the bottom-most script which caused the frame to be labelled
     * as an ad.
     */
    public org.openqa.selenium.devtools.v130.runtime.model.ScriptId getScriptId() {
        return scriptId;
    }

    /**
     * Id of adScriptId's debugger.
     */
    public org.openqa.selenium.devtools.v130.runtime.model.UniqueDebuggerId getDebuggerId() {
        return debuggerId;
    }

    private static AdScriptId fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v130.runtime.model.ScriptId scriptId = null;
        org.openqa.selenium.devtools.v130.runtime.model.UniqueDebuggerId debuggerId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "scriptId":
                    scriptId = input.read(org.openqa.selenium.devtools.v130.runtime.model.ScriptId.class);
                    break;
                case "debuggerId":
                    debuggerId = input.read(org.openqa.selenium.devtools.v130.runtime.model.UniqueDebuggerId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AdScriptId(scriptId, debuggerId);
    }
}
