package org.openqa.selenium.devtools.v131.tracing.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Backend type to use for tracing. `chrome` uses the Chrome-integrated
 * tracing service and is supported on all platforms. `system` is only
 * supported on Chrome OS and uses the Perfetto system tracing service.
 * `auto` chooses `system` when the perfettoConfig provided to Tracing.start
 * specifies at least one non-Chrome data source; otherwise uses `chrome`.
 */
@org.openqa.selenium.Beta()
public enum TracingBackend {

    AUTO("auto"), CHROME("chrome"), SYSTEM("system");

    private String value;

    TracingBackend(String value) {
        this.value = value;
    }

    public static TracingBackend fromString(String s) {
        return java.util.Arrays.stream(TracingBackend.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within TracingBackend "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static TracingBackend fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
