package org.openqa.selenium.devtools.v131.webauthn.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Triggered when a credential is deleted, e.g. through
 * PublicKeyCredential.signalUnknownCredential().
 */
public class CredentialDeleted {

    private final org.openqa.selenium.devtools.v131.webauthn.model.AuthenticatorId authenticatorId;

    private final java.lang.String credentialId;

    public CredentialDeleted(org.openqa.selenium.devtools.v131.webauthn.model.AuthenticatorId authenticatorId, java.lang.String credentialId) {
        this.authenticatorId = java.util.Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        this.credentialId = java.util.Objects.requireNonNull(credentialId, "credentialId is required");
    }

    public org.openqa.selenium.devtools.v131.webauthn.model.AuthenticatorId getAuthenticatorId() {
        return authenticatorId;
    }

    public java.lang.String getCredentialId() {
        return credentialId;
    }

    private static CredentialDeleted fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v131.webauthn.model.AuthenticatorId authenticatorId = null;
        java.lang.String credentialId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "authenticatorId":
                    authenticatorId = input.read(org.openqa.selenium.devtools.v131.webauthn.model.AuthenticatorId.class);
                    break;
                case "credentialId":
                    credentialId = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CredentialDeleted(authenticatorId, credentialId);
    }
}
