/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.emulation.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class DevicePosture {
    private final Type type;

    public DevicePosture(Type type) {
        this.type = Objects.requireNonNull(type, "type is required");
    }

    public Type getType() {
        return this.type;
    }

    private static DevicePosture fromJson(JsonInput input) {
        Type type = null;
        input.beginObject();
        block6: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block6;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DevicePosture(type);
    }

    public static enum Type {
        CONTINUOUS("continuous"),
        FOLDED("folded");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

