package org.openqa.selenium.devtools.v131.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum PressureState {

    NOMINAL("nominal"), FAIR("fair"), SERIOUS("serious"), CRITICAL("critical");

    private String value;

    PressureState(String value) {
        this.value = value;
    }

    public static PressureState fromString(String s) {
        return java.util.Arrays.stream(PressureState.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PressureState "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PressureState fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
