package org.openqa.selenium.devtools.v131.extensions;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * Defines commands and events for browser extensions.
 */
@Beta()
public class Extensions {

    /**
     * Installs an unpacked extension from the filesystem similar to
     * --load-extension CLI flags. Returns extension ID once the extension
     * has been installed. Available if the client is connected using the
     * --remote-debugging-pipe flag and the --enable-unsafe-extension-debugging
     * flag is set.
     */
    public static Command<java.lang.String> loadUnpacked(java.lang.String path) {
        java.util.Objects.requireNonNull(path, "path is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("path", path);
        return new Command<>("Extensions.loadUnpacked", Map.copyOf(params), ConverterFunctions.map("id", java.lang.String.class));
    }

    /**
     * Gets data from extension storage in the given `storageArea`. If `keys` is
     * specified, these are used to filter the result.
     */
    public static Command<java.util.Map<String, Object>> getStorageItems(java.lang.String id, org.openqa.selenium.devtools.v131.extensions.model.StorageArea storageArea, java.util.Optional<java.util.List<java.lang.String>> keys) {
        java.util.Objects.requireNonNull(id, "id is required");
        java.util.Objects.requireNonNull(storageArea, "storageArea is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("id", id);
        params.put("storageArea", storageArea);
        keys.ifPresent(p -> params.put("keys", p));
        return new Command<>("Extensions.getStorageItems", Map.copyOf(params), ConverterFunctions.map("data", java.util.Map.class));
    }

    /**
     * Removes `keys` from extension storage in the given `storageArea`.
     */
    public static Command<Void> removeStorageItems(java.lang.String id, org.openqa.selenium.devtools.v131.extensions.model.StorageArea storageArea, java.util.List<java.lang.String> keys) {
        java.util.Objects.requireNonNull(id, "id is required");
        java.util.Objects.requireNonNull(storageArea, "storageArea is required");
        java.util.Objects.requireNonNull(keys, "keys is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("id", id);
        params.put("storageArea", storageArea);
        params.put("keys", keys);
        return new Command<>("Extensions.removeStorageItems", Map.copyOf(params));
    }

    /**
     * Clears extension storage in the given `storageArea`.
     */
    public static Command<Void> clearStorageItems(java.lang.String id, org.openqa.selenium.devtools.v131.extensions.model.StorageArea storageArea) {
        java.util.Objects.requireNonNull(id, "id is required");
        java.util.Objects.requireNonNull(storageArea, "storageArea is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("id", id);
        params.put("storageArea", storageArea);
        return new Command<>("Extensions.clearStorageItems", Map.copyOf(params));
    }

    /**
     * Sets `values` in extension storage in the given `storageArea`. The provided `values`
     * will be merged with existing values in the storage area.
     */
    public static Command<Void> setStorageItems(java.lang.String id, org.openqa.selenium.devtools.v131.extensions.model.StorageArea storageArea, java.util.Map<String, Object> values) {
        java.util.Objects.requireNonNull(id, "id is required");
        java.util.Objects.requireNonNull(storageArea, "storageArea is required");
        java.util.Objects.requireNonNull(values, "values is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("id", id);
        params.put("storageArea", storageArea);
        params.put("values", values);
        return new Command<>("Extensions.setStorageItems", Map.copyOf(params));
    }
}
