/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.storage.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v131.storage.model.AttributionReportingFilterDataEntry;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AttributionReportingFilterConfig {
    private final List<AttributionReportingFilterDataEntry> filterValues;
    private final Optional<Integer> lookbackWindow;

    public AttributionReportingFilterConfig(List<AttributionReportingFilterDataEntry> filterValues, Optional<Integer> lookbackWindow) {
        this.filterValues = Objects.requireNonNull(filterValues, "filterValues is required");
        this.lookbackWindow = lookbackWindow;
    }

    public List<AttributionReportingFilterDataEntry> getFilterValues() {
        return this.filterValues;
    }

    public Optional<Integer> getLookbackWindow() {
        return this.lookbackWindow;
    }

    private static AttributionReportingFilterConfig fromJson(JsonInput input) {
        List filterValues = null;
        Optional<Integer> lookbackWindow = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "filterValues": {
                    filterValues = input.readArray(AttributionReportingFilterDataEntry.class);
                    continue block8;
                }
                case "lookbackWindow": {
                    lookbackWindow = Optional.ofNullable(input.nextNumber().intValue());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AttributionReportingFilterConfig(filterValues, lookbackWindow);
    }
}

