package org.openqa.selenium.devtools.v132.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A cookie associated with the request which may or may not be sent with it.
 * Includes the cookies itself and reasons for blocking or exemption.
 */
@org.openqa.selenium.Beta()
public class AssociatedCookie {

    private final org.openqa.selenium.devtools.v132.network.model.Cookie cookie;

    private final java.util.List<org.openqa.selenium.devtools.v132.network.model.CookieBlockedReason> blockedReasons;

    private final java.util.Optional<org.openqa.selenium.devtools.v132.network.model.CookieExemptionReason> exemptionReason;

    public AssociatedCookie(org.openqa.selenium.devtools.v132.network.model.Cookie cookie, java.util.List<org.openqa.selenium.devtools.v132.network.model.CookieBlockedReason> blockedReasons, java.util.Optional<org.openqa.selenium.devtools.v132.network.model.CookieExemptionReason> exemptionReason) {
        this.cookie = java.util.Objects.requireNonNull(cookie, "cookie is required");
        this.blockedReasons = java.util.Objects.requireNonNull(blockedReasons, "blockedReasons is required");
        this.exemptionReason = exemptionReason;
    }

    /**
     * The cookie object representing the cookie which was not sent.
     */
    public org.openqa.selenium.devtools.v132.network.model.Cookie getCookie() {
        return cookie;
    }

    /**
     * The reason(s) the cookie was blocked. If empty means the cookie is included.
     */
    public java.util.List<org.openqa.selenium.devtools.v132.network.model.CookieBlockedReason> getBlockedReasons() {
        return blockedReasons;
    }

    /**
     * The reason the cookie should have been blocked by 3PCD but is exempted. A cookie could
     * only have at most one exemption reason.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v132.network.model.CookieExemptionReason> getExemptionReason() {
        return exemptionReason;
    }

    private static AssociatedCookie fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v132.network.model.Cookie cookie = null;
        java.util.List<org.openqa.selenium.devtools.v132.network.model.CookieBlockedReason> blockedReasons = null;
        java.util.Optional<org.openqa.selenium.devtools.v132.network.model.CookieExemptionReason> exemptionReason = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "cookie":
                    cookie = input.read(org.openqa.selenium.devtools.v132.network.model.Cookie.class);
                    break;
                case "blockedReasons":
                    blockedReasons = input.readArray(org.openqa.selenium.devtools.v132.network.model.CookieBlockedReason.class);
                    break;
                case "exemptionReason":
                    exemptionReason = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v132.network.model.CookieExemptionReason.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AssociatedCookie(cookie, blockedReasons, exemptionReason);
    }
}
