/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v132.domsnapshot.model;

import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v132.domsnapshot.model.Rectangle;
import org.openqa.selenium.json.JsonInput;

public class TextBoxSnapshot {
    private final List<Integer> layoutIndex;
    private final List<Rectangle> bounds;
    private final List<Integer> start;
    private final List<Integer> length;

    public TextBoxSnapshot(List<Integer> layoutIndex, List<Rectangle> bounds, List<Integer> start, List<Integer> length) {
        this.layoutIndex = Objects.requireNonNull(layoutIndex, "layoutIndex is required");
        this.bounds = Objects.requireNonNull(bounds, "bounds is required");
        this.start = Objects.requireNonNull(start, "start is required");
        this.length = Objects.requireNonNull(length, "length is required");
    }

    public List<Integer> getLayoutIndex() {
        return this.layoutIndex;
    }

    public List<Rectangle> getBounds() {
        return this.bounds;
    }

    public List<Integer> getStart() {
        return this.start;
    }

    public List<Integer> getLength() {
        return this.length;
    }

    private static TextBoxSnapshot fromJson(JsonInput input) {
        List layoutIndex = null;
        List bounds = null;
        List start = null;
        List length = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "layoutIndex": {
                    layoutIndex = input.readArray(Integer.class);
                    continue block12;
                }
                case "bounds": {
                    bounds = input.readArray(Rectangle.class);
                    continue block12;
                }
                case "start": {
                    start = input.readArray(Integer.class);
                    continue block12;
                }
                case "length": {
                    length = input.readArray(Integer.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TextBoxSnapshot(layoutIndex, bounds, start, length);
    }
}

