/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v135.memory;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v135.memory.model.DOMCounter;
import org.openqa.selenium.devtools.v135.memory.model.PressureLevel;
import org.openqa.selenium.devtools.v135.memory.model.SamplingProfile;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Memory {
    public static Command<GetDOMCountersResponse> getDOMCounters() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Memory.getDOMCounters", Map.copyOf(params), input -> (GetDOMCountersResponse)input.read(GetDOMCountersResponse.class));
    }

    public static Command<List<DOMCounter>> getDOMCountersForLeakDetection() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Memory.getDOMCountersForLeakDetection", Map.copyOf(params), ConverterFunctions.map((String)"counters", input -> input.readArray(DOMCounter.class)));
    }

    public static Command<Void> prepareForLeakDetection() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Memory.prepareForLeakDetection", Map.copyOf(params));
    }

    public static Command<Void> forciblyPurgeJavaScriptMemory() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Memory.forciblyPurgeJavaScriptMemory", Map.copyOf(params));
    }

    public static Command<Void> setPressureNotificationsSuppressed(Boolean suppressed) {
        Objects.requireNonNull(suppressed, "suppressed is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("suppressed", suppressed);
        return new Command("Memory.setPressureNotificationsSuppressed", Map.copyOf(params));
    }

    public static Command<Void> simulatePressureNotification(PressureLevel level) {
        Objects.requireNonNull(level, "level is required");
        LinkedHashMap<String, PressureLevel> params = new LinkedHashMap<String, PressureLevel>();
        params.put("level", level);
        return new Command("Memory.simulatePressureNotification", Map.copyOf(params));
    }

    public static Command<Void> startSampling(Optional<Integer> samplingInterval, Optional<Boolean> suppressRandomness) {
        LinkedHashMap params = new LinkedHashMap();
        samplingInterval.ifPresent(p -> params.put("samplingInterval", p));
        suppressRandomness.ifPresent(p -> params.put("suppressRandomness", p));
        return new Command("Memory.startSampling", Map.copyOf(params));
    }

    public static Command<Void> stopSampling() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Memory.stopSampling", Map.copyOf(params));
    }

    public static Command<SamplingProfile> getAllTimeSamplingProfile() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Memory.getAllTimeSamplingProfile", Map.copyOf(params), ConverterFunctions.map((String)"profile", SamplingProfile.class));
    }

    public static Command<SamplingProfile> getBrowserSamplingProfile() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Memory.getBrowserSamplingProfile", Map.copyOf(params), ConverterFunctions.map((String)"profile", SamplingProfile.class));
    }

    public static Command<SamplingProfile> getSamplingProfile() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Memory.getSamplingProfile", Map.copyOf(params), ConverterFunctions.map((String)"profile", SamplingProfile.class));
    }

    public static class GetDOMCountersResponse {
        private final Integer documents;
        private final Integer nodes;
        private final Integer jsEventListeners;

        public GetDOMCountersResponse(Integer documents, Integer nodes, Integer jsEventListeners) {
            this.documents = Objects.requireNonNull(documents, "documents is required");
            this.nodes = Objects.requireNonNull(nodes, "nodes is required");
            this.jsEventListeners = Objects.requireNonNull(jsEventListeners, "jsEventListeners is required");
        }

        public Integer getDocuments() {
            return this.documents;
        }

        public Integer getNodes() {
            return this.nodes;
        }

        public Integer getJsEventListeners() {
            return this.jsEventListeners;
        }

        private static GetDOMCountersResponse fromJson(JsonInput input) {
            Integer documents = 0;
            Integer nodes = 0;
            Integer jsEventListeners = 0;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "documents": {
                        documents = input.nextNumber().intValue();
                        continue block10;
                    }
                    case "nodes": {
                        nodes = input.nextNumber().intValue();
                        continue block10;
                    }
                    case "jsEventListeners": {
                        jsEventListeners = input.nextNumber().intValue();
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetDOMCountersResponse(documents, nodes, jsEventListeners);
        }
    }
}

