package org.openqa.selenium.devtools.v141.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Representation of a custom property registration through CSS.registerProperty
 */
public class CSSPropertyRegistration {

    private final java.lang.String propertyName;

    private final java.util.Optional<org.openqa.selenium.devtools.v141.css.model.Value> initialValue;

    private final java.lang.Boolean inherits;

    private final java.lang.String syntax;

    public CSSPropertyRegistration(java.lang.String propertyName, java.util.Optional<org.openqa.selenium.devtools.v141.css.model.Value> initialValue, java.lang.Boolean inherits, java.lang.String syntax) {
        this.propertyName = java.util.Objects.requireNonNull(propertyName, "propertyName is required");
        this.initialValue = initialValue;
        this.inherits = java.util.Objects.requireNonNull(inherits, "inherits is required");
        this.syntax = java.util.Objects.requireNonNull(syntax, "syntax is required");
    }

    public java.lang.String getPropertyName() {
        return propertyName;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v141.css.model.Value> getInitialValue() {
        return initialValue;
    }

    public java.lang.Boolean getInherits() {
        return inherits;
    }

    public java.lang.String getSyntax() {
        return syntax;
    }

    private static CSSPropertyRegistration fromJson(JsonInput input) {
        java.lang.String propertyName = null;
        java.util.Optional<org.openqa.selenium.devtools.v141.css.model.Value> initialValue = java.util.Optional.empty();
        java.lang.Boolean inherits = false;
        java.lang.String syntax = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "propertyName":
                    propertyName = input.nextString();
                    break;
                case "initialValue":
                    initialValue = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v141.css.model.Value.class));
                    break;
                case "inherits":
                    inherits = input.nextBoolean();
                    break;
                case "syntax":
                    syntax = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSPropertyRegistration(propertyName, initialValue, inherits, syntax);
    }
}
