package org.openqa.selenium.devtools.v141.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when data is sent to tcp direct socket stream.
 */
@org.openqa.selenium.Beta()
public class DirectTCPSocketChunkSent {

    private final org.openqa.selenium.devtools.v141.network.model.RequestId identifier;

    private final java.lang.String data;

    private final org.openqa.selenium.devtools.v141.network.model.MonotonicTime timestamp;

    public DirectTCPSocketChunkSent(org.openqa.selenium.devtools.v141.network.model.RequestId identifier, java.lang.String data, org.openqa.selenium.devtools.v141.network.model.MonotonicTime timestamp) {
        this.identifier = java.util.Objects.requireNonNull(identifier, "identifier is required");
        this.data = java.util.Objects.requireNonNull(data, "data is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
    }

    public org.openqa.selenium.devtools.v141.network.model.RequestId getIdentifier() {
        return identifier;
    }

    public java.lang.String getData() {
        return data;
    }

    public org.openqa.selenium.devtools.v141.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    private static DirectTCPSocketChunkSent fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v141.network.model.RequestId identifier = null;
        java.lang.String data = null;
        org.openqa.selenium.devtools.v141.network.model.MonotonicTime timestamp = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "identifier":
                    identifier = input.read(org.openqa.selenium.devtools.v141.network.model.RequestId.class);
                    break;
                case "data":
                    data = input.nextString();
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v141.network.model.MonotonicTime.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DirectTCPSocketChunkSent(identifier, data, timestamp);
    }
}
