/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v142.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v142.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DirectTCPSocketOpened {
    private final RequestId identifier;
    private final String remoteAddr;
    private final Integer remotePort;
    private final MonotonicTime timestamp;
    private final Optional<String> localAddr;
    private final Optional<Integer> localPort;

    public DirectTCPSocketOpened(RequestId identifier, String remoteAddr, Integer remotePort, MonotonicTime timestamp, Optional<String> localAddr, Optional<Integer> localPort) {
        this.identifier = Objects.requireNonNull(identifier, "identifier is required");
        this.remoteAddr = Objects.requireNonNull(remoteAddr, "remoteAddr is required");
        this.remotePort = Objects.requireNonNull(remotePort, "remotePort is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.localAddr = localAddr;
        this.localPort = localPort;
    }

    public RequestId getIdentifier() {
        return this.identifier;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getLocalAddr() {
        return this.localAddr;
    }

    public Optional<Integer> getLocalPort() {
        return this.localPort;
    }

    private static DirectTCPSocketOpened fromJson(JsonInput input) {
        RequestId identifier = null;
        String remoteAddr = null;
        Integer remotePort = 0;
        MonotonicTime timestamp = null;
        Optional<String> localAddr = Optional.empty();
        Optional<Integer> localPort = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "identifier": {
                    identifier = (RequestId)input.read(RequestId.class);
                    continue block16;
                }
                case "remoteAddr": {
                    remoteAddr = input.nextString();
                    continue block16;
                }
                case "remotePort": {
                    remotePort = input.nextNumber().intValue();
                    continue block16;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block16;
                }
                case "localAddr": {
                    localAddr = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "localPort": {
                    localPort = Optional.ofNullable(input.nextNumber().intValue());
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DirectTCPSocketOpened(identifier, remoteAddr, remotePort, timestamp, localAddr, localPort);
    }
}

