/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.page.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v85.page.model.TransitionType;
import org.openqa.selenium.json.JsonInput;

public class NavigationEntry {
    private final Integer id;
    private final String url;
    private final String userTypedURL;
    private final String title;
    private final TransitionType transitionType;

    public NavigationEntry(Integer id, String url, String userTypedURL, String title, TransitionType transitionType) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.userTypedURL = Objects.requireNonNull(userTypedURL, "userTypedURL is required");
        this.title = Objects.requireNonNull(title, "title is required");
        this.transitionType = Objects.requireNonNull(transitionType, "transitionType is required");
    }

    public Integer getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserTypedURL() {
        return this.userTypedURL;
    }

    public String getTitle() {
        return this.title;
    }

    public TransitionType getTransitionType() {
        return this.transitionType;
    }

    private static NavigationEntry fromJson(JsonInput input) {
        Integer id = 0;
        String url = null;
        String userTypedURL = null;
        String title = null;
        TransitionType transitionType = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = input.nextNumber().intValue();
                    continue block14;
                }
                case "url": {
                    url = input.nextString();
                    continue block14;
                }
                case "userTypedURL": {
                    userTypedURL = input.nextString();
                    continue block14;
                }
                case "title": {
                    title = input.nextString();
                    continue block14;
                }
                case "transitionType": {
                    transitionType = (TransitionType)((Object)input.read(TransitionType.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NavigationEntry(id, url, userTypedURL, title, transitionType);
    }
}

