/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v96.network.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v96.network.model.BlockedSetCookieWithReason;
import org.openqa.selenium.devtools.v96.network.model.Headers;
import org.openqa.selenium.devtools.v96.network.model.IPAddressSpace;
import org.openqa.selenium.devtools.v96.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ResponseReceivedExtraInfo {
    private final RequestId requestId;
    private final List<BlockedSetCookieWithReason> blockedCookies;
    private final Headers headers;
    private final IPAddressSpace resourceIPAddressSpace;
    private final Integer statusCode;
    private final Optional<String> headersText;

    public ResponseReceivedExtraInfo(RequestId requestId, List<BlockedSetCookieWithReason> blockedCookies, Headers headers, IPAddressSpace resourceIPAddressSpace, Integer statusCode, Optional<String> headersText) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.blockedCookies = Objects.requireNonNull(blockedCookies, "blockedCookies is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.resourceIPAddressSpace = Objects.requireNonNull(resourceIPAddressSpace, "resourceIPAddressSpace is required");
        this.statusCode = Objects.requireNonNull(statusCode, "statusCode is required");
        this.headersText = headersText;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public List<BlockedSetCookieWithReason> getBlockedCookies() {
        return this.blockedCookies;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public IPAddressSpace getResourceIPAddressSpace() {
        return this.resourceIPAddressSpace;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public Optional<String> getHeadersText() {
        return this.headersText;
    }

    private static ResponseReceivedExtraInfo fromJson(JsonInput input) {
        RequestId requestId = null;
        List blockedCookies = null;
        Headers headers = null;
        IPAddressSpace resourceIPAddressSpace = null;
        Integer statusCode = 0;
        Optional<String> headersText = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block16;
                }
                case "blockedCookies": {
                    blockedCookies = (List)input.read(new TypeToken<List<BlockedSetCookieWithReason>>(){}.getType());
                    continue block16;
                }
                case "headers": {
                    headers = (Headers)((Object)input.read(Headers.class));
                    continue block16;
                }
                case "resourceIPAddressSpace": {
                    resourceIPAddressSpace = (IPAddressSpace)((Object)input.read(IPAddressSpace.class));
                    continue block16;
                }
                case "statusCode": {
                    statusCode = input.nextNumber().intValue();
                    continue block16;
                }
                case "headersText": {
                    headersText = Optional.ofNullable(input.nextString());
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ResponseReceivedExtraInfo(requestId, blockedCookies, headers, resourceIPAddressSpace, statusCode, headersText);
    }
}

