/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.Command;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxWebElement
implements RenderedWebElement,
Locatable,
FindsByXPath,
FindsByLinkText,
FindsById,
FindsByCssSelector,
FindsByName,
FindsByTagName,
FindsByClassName {
    private final FirefoxDriver parent;
    private final String elementId;

    public FirefoxWebElement(FirefoxDriver parent, String elementId) {
        this.parent = parent;
        this.elementId = elementId;
    }

    public void click() {
        this.sendMessage(UnsupportedOperationException.class, "click", new Object[0]);
    }

    public void hover() {
        this.sendMessage(WebDriverException.class, "hover", new Object[0]);
    }

    public void submit() {
        this.sendMessage(WebDriverException.class, "submit", new Object[0]);
    }

    public String getValue() {
        try {
            return this.sendMessage(WebDriverException.class, "getValue", new Object[0]);
        }
        catch (WebDriverException e) {
            return null;
        }
    }

    public void clear() {
        this.sendMessage(UnsupportedOperationException.class, "clear", new Object[0]);
    }

    public void sendKeys(CharSequence ... value) {
        StringBuilder builder = new StringBuilder();
        for (CharSequence seq : value) {
            builder.append(seq);
        }
        this.sendMessage(UnsupportedOperationException.class, "sendKeys", builder.toString());
    }

    public String getTagName() {
        String name = this.sendMessage(WebDriverException.class, "getTagName", new Object[0]);
        return name;
    }

    public String getAttribute(String name) {
        return this.sendMessage(WebDriverException.class, "getAttribute", name);
    }

    public boolean toggle() {
        this.sendMessage(UnsupportedOperationException.class, "toggle", new Object[0]);
        return this.isSelected();
    }

    public boolean isSelected() {
        String value = this.sendMessage(WebDriverException.class, "isSelected", new Object[0]);
        return Boolean.parseBoolean(value);
    }

    public void setSelected() {
        this.sendMessage(UnsupportedOperationException.class, "setSelected", new Object[0]);
    }

    public boolean isEnabled() {
        String value = this.getAttribute("disabled");
        return !Boolean.parseBoolean(value);
    }

    public String getText() {
        return this.sendMessage(WebDriverException.class, "getText", new Object[0]);
    }

    public boolean isDisplayed() {
        return Boolean.parseBoolean(this.sendMessage(WebDriverException.class, "isDisplayed", new Object[0]));
    }

    public Point getLocation() {
        JSONObject result = (JSONObject)this.executeCommand(WebDriverException.class, "getLocation", new Object[0]);
        try {
            return new Point(result.getInt("x"), result.getInt("y"));
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public Dimension getSize() {
        JSONObject result = (JSONObject)this.executeCommand(WebDriverException.class, "getSize", new Object[0]);
        try {
            return new Dimension(result.getInt("width"), result.getInt("height"));
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void dragAndDropBy(int moveRight, int moveDown) {
        this.sendMessage(UnsupportedOperationException.class, "dragElement", moveRight, moveDown);
    }

    public void dragAndDropOn(RenderedWebElement element) {
        Point currentLocation = this.getLocation();
        Point destination = element.getLocation();
        this.dragAndDropBy(destination.x - currentLocation.x, destination.y - currentLocation.y);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElementByXPath(String xpath) {
        return this.findChildElement("xpath", xpath);
    }

    public List<WebElement> findElementsByXPath(String xpath) {
        return this.findChildElements("xpath", xpath);
    }

    public WebElement findElementByLinkText(String linkText) {
        return this.findChildElement("link text", linkText);
    }

    public List<WebElement> findElementsByLinkText(String linkText) {
        return this.findChildElements("link text", linkText);
    }

    public WebElement findElementByPartialLinkText(String text) {
        return this.findChildElement("partial link text", text);
    }

    public List<WebElement> findElementsByPartialLinkText(String text) {
        return this.findChildElements("partial link text", text);
    }

    public WebElement findElementById(String id) {
        return this.findChildElement("id", id);
    }

    public List<WebElement> findElementsById(String id) {
        return this.findChildElements("id", id);
    }

    public WebElement findElementByName(String name) {
        return this.findChildElement("name", name);
    }

    public List<WebElement> findElementsByName(String name) {
        return this.findChildElements("name", name);
    }

    public WebElement findElementByTagName(String tagName) {
        return this.findChildElement("tag name", tagName);
    }

    public List<WebElement> findElementsByTagName(String tagName) {
        return this.findChildElements("tag name", tagName);
    }

    public WebElement findElementByClassName(String className) {
        return this.findChildElement("class name", className);
    }

    public List<WebElement> findElementsByClassName(String className) {
        return this.findChildElements("class name", className);
    }

    public WebElement findElementByCssSelector(String using) {
        return this.findChildElement("css selector", using);
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.findChildElements("css selector", using);
    }

    private WebElement findChildElement(String using, String value) {
        String id = this.sendMessage(NoSuchElementException.class, "findChildElement", this.buildSearchParamsMap(using, value));
        return new FirefoxWebElement(this.parent, id);
    }

    private List<WebElement> findChildElements(String using, String value) {
        JSONArray ids = (JSONArray)this.executeCommand(WebDriverException.class, "findChildElements", this.buildSearchParamsMap(using, value));
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        try {
            for (int i = 0; i < ids.length(); ++i) {
                elements.add((WebElement)new FirefoxWebElement(this.parent, ids.getString(i)));
            }
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
        return elements;
    }

    private Map<String, String> buildSearchParamsMap(String using, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", this.elementId);
        map.put("using", using);
        map.put("value", value);
        return map;
    }

    public String getValueOfCssProperty(String propertyName) {
        return this.sendMessage(WebDriverException.class, "getValueOfCssProperty", propertyName);
    }

    private String sendMessage(Class<? extends RuntimeException> throwOnFailure, String methodName, Object ... parameters) {
        Object result = this.executeCommand(throwOnFailure, methodName, parameters);
        return result == null ? null : String.valueOf(result);
    }

    private Object executeCommand(Class<? extends RuntimeException> throwOnFailure, String methodName, Object ... parameters) {
        return this.parent.executeCommand(throwOnFailure, new Command(this.parent.context, this.elementId, methodName, parameters));
    }

    public String getElementId() {
        return this.elementId;
    }

    public Point getLocationOnScreenOnceScrolledIntoView() {
        try {
            JSONObject mapped = (JSONObject)this.executeCommand(WebDriverException.class, "getLocationOnceScrolledIntoView", new Object[0]);
            return new Point(mapped.getInt("x"), mapped.getInt("y"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        if (other instanceof WrapsElement) {
            other = ((WrapsElement)obj).getWrappedElement();
        }
        if (!(other instanceof FirefoxWebElement)) {
            return false;
        }
        return this.elementId.equals(((FirefoxWebElement)other).elementId);
    }

    public int hashCode() {
        return this.elementId.hashCode();
    }
}

