/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Platform;
import org.openqa.selenium.ProcessUtils;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.Executable;
import org.openqa.selenium.firefox.internal.Streams;
import org.openqa.selenium.internal.FileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxBinary {
    private static final String NO_FOCUS_LIBRARY_NAME = "x_ignore_nofocus.so";
    private final Map<String, String> extraEnv = new HashMap<String, String>();
    private final Executable executable;
    private Process process;
    private long timeout = TimeUnit.SECONDS.toMillis(45L);
    private OutputStream stream;
    private Thread outputWatcher;
    private FirefoxProfile profile;

    public FirefoxBinary() {
        this(null);
    }

    public FirefoxBinary(File pathToFirefoxBinary) {
        this.executable = new Executable(pathToFirefoxBinary);
    }

    protected boolean isOnLinux() {
        return Platform.getCurrent().is(Platform.LINUX);
    }

    public void startProfile(FirefoxProfile profile, String ... commandLineFlags) throws IOException {
        String profileAbsPath = profile.getProfileDir().getAbsolutePath();
        this.setEnvironmentProperty("XRE_PROFILE_PATH", profileAbsPath);
        this.setEnvironmentProperty("MOZ_NO_REMOTE", "1");
        if (this.isOnLinux() && (profile.enableNativeEvents() || profile.alwaysLoadNoFocusLib())) {
            this.modifyLinkLibraryPath(profile);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getExecutable().getPath());
        commands.add("--verbose");
        commands.addAll(Arrays.asList(commandLineFlags));
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.redirectErrorStream(true);
        builder.environment().putAll(this.getExtraEnv());
        this.getExecutable().setLibraryPath(builder, this.getExtraEnv());
        if (this.stream == null) {
            this.stream = this.getExecutable().getDefaultOutputStream();
        }
        this.startFirefoxProcess(builder);
        this.copeWithTheStrangenessOfTheMac(builder);
        this.startOutputWatcher();
    }

    protected void startFirefoxProcess(ProcessBuilder builder) throws IOException {
        this.process = builder.start();
    }

    protected void startOutputWatcher() {
        this.outputWatcher = new Thread((Runnable)new OutputWatcher(this.process, this.stream), "Firefox output watcher");
        this.outputWatcher.start();
    }

    protected Executable getExecutable() {
        return this.executable;
    }

    protected Map<String, String> getExtraEnv() {
        return this.extraEnv;
    }

    protected void modifyLinkLibraryPath(FirefoxProfile profile) {
        String existingLdLibPath = System.getenv("LD_LIBRARY_PATH");
        String newLdLibPath = this.extractAndCheck(profile, NO_FOCUS_LIBRARY_NAME, "x86", "amd64");
        if (existingLdLibPath != null && !existingLdLibPath.equals("")) {
            newLdLibPath = newLdLibPath + existingLdLibPath;
        }
        this.setEnvironmentProperty("LD_LIBRARY_PATH", newLdLibPath);
        this.setEnvironmentProperty("LD_PRELOAD", NO_FOCUS_LIBRARY_NAME);
    }

    protected String extractAndCheck(FirefoxProfile profile, String noFocusSoName, String jarPath32Bit, String jarPath64Bit) {
        HashSet<String> pathsSet = new HashSet<String>();
        pathsSet.add(jarPath32Bit);
        pathsSet.add(jarPath64Bit);
        StringBuilder builtPath = new StringBuilder();
        for (String path : pathsSet) {
            try {
                FileHandler.copyResource((File)profile.getProfileDir(), this.getClass(), (String[])new String[]{path + File.separator + noFocusSoName});
            }
            catch (IOException e) {
                if (Boolean.getBoolean("webdriver.development")) {
                    System.err.println("Exception unpacking required library, but in development mode. Continuing");
                }
                throw new WebDriverException((Throwable)e);
            }
            String outSoPath = profile.getProfileDir().getAbsolutePath() + File.separator + path;
            File file = new File(outSoPath, noFocusSoName);
            if (!file.exists()) {
                throw new WebDriverException("Could not locate " + path + ": " + "native events will not work.");
            }
            builtPath.append(outSoPath).append(":");
        }
        return builtPath.toString();
    }

    protected void copeWithTheStrangenessOfTheMac(ProcessBuilder builder) throws IOException {
        if (Platform.getCurrent().is(Platform.MAC)) {
            try {
                this.sleep(300L);
                if (this.process.exitValue() == 0) {
                    return;
                }
                this.sleep(10000L);
                this.startFirefoxProcess(builder);
            }
            catch (IllegalThreadStateException e) {
                // empty catch block
            }
            try {
                this.sleep(300L);
                this.process.exitValue();
                if (this.process.exitValue() == 0) {
                    return;
                }
                StringBuilder message = new StringBuilder("Unable to start firefox cleanly.\n");
                message.append(this.getConsoleOutput()).append("\n");
                message.append("Exit value: ").append(this.process.exitValue()).append("\n");
                message.append("Ran from: ").append(builder.command()).append("\n");
                throw new WebDriverException(message.toString());
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    public void setEnvironmentProperty(String propertyName, String value) {
        if (propertyName == null || value == null) {
            throw new WebDriverException(String.format("You must set both the property name and value: %s, %s", propertyName, value));
        }
        this.extraEnv.put(propertyName, value);
    }

    public void createProfile(String profileName) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.executable.getPath(), "--verbose", "-CreateProfile", profileName).redirectErrorStream(true);
        builder.environment().put("MOZ_NO_REMOTE", "1");
        if (this.stream == null) {
            this.stream = this.executable.getDefaultOutputStream();
        }
        this.startFirefoxProcess(builder);
        this.outputWatcher = new Thread(new OutputWatcher(this.process, this.stream));
        this.outputWatcher.start();
    }

    public void waitFor() throws InterruptedException, IOException {
        this.process.waitFor();
    }

    public String getConsoleOutput() throws IOException {
        if (this.process == null) {
            return null;
        }
        return Streams.drainStream(this.stream);
    }

    private void sleep(long timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void clean(FirefoxProfile profile) throws IOException {
        this.startProfile(profile, "-silent");
        try {
            this.waitFor();
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            while (profile.isRunning()) {
                this.sleep(500L);
            }
            do {
                this.sleep(500L);
            } while (profile.isRunning());
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return "FirefoxBinary(" + this.executable.getPath() + ")";
    }

    public void setOutputWatcher(OutputStream stream) {
        this.stream = stream;
    }

    public void quit() {
        ProcessUtils.killProcess((Process)this.process);
    }

    private static class OutputWatcher
    implements Runnable {
        private Process process;
        private OutputStream stream;

        public OutputWatcher(Process process, OutputStream stream) {
            this.process = process;
            this.stream = stream;
        }

        public void run() {
            int in = 0;
            while (in != -1) {
                try {
                    in = this.process.getInputStream().read();
                    this.stream.write(in);
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }
    }
}

