/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.Command;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.AbstractExtensionConnection;
import org.openqa.selenium.firefox.internal.CircularOutputStream;
import org.openqa.selenium.firefox.internal.Lock;

public class NewProfileExtensionConnection
extends AbstractExtensionConnection {
    private FirefoxBinary process;
    private FirefoxProfile profile;
    private int bufferSize = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewProfileExtensionConnection(Lock lock, FirefoxBinary binary, FirefoxProfile profile, String host) throws IOException {
        this.profile = profile;
        this.process = binary == null ? new FirefoxBinary() : binary;
        lock.lock(this.process.getTimeout());
        try {
            int portToUse = this.determineNextFreePort(host, profile.getPort());
            this.process.setOutputWatcher(new CircularOutputStream(this.bufferSize));
            profile.setPort(portToUse);
            profile.updateUserPrefs();
            this.process.clean(profile);
            this.process.startProfile(profile, new String[0]);
            this.setAddress(host, portToUse);
            this.connectToBrowser(this.process.getTimeout());
        }
        finally {
            lock.unlock();
        }
    }

    protected void connectToBrowser(long timeToWaitInMilliSeconds) throws IOException {
        try {
            super.connectToBrowser(timeToWaitInMilliSeconds);
        }
        catch (IOException e) {
            throw new WebDriverException(String.format("Failed to connect to binary %s on port %d; process output follows: \n%s", this.process.toString(), this.profile.getPort(), this.process.getConsoleOutput()), (Throwable)e);
        }
        catch (WebDriverException e) {
            throw new WebDriverException(String.format("Failed to connect to binary %s on port %d; process output follows: \n%s", this.process.toString(), this.profile.getPort(), this.process.getConsoleOutput()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int determineNextFreePort(String host, int port) throws IOException {
        int newport;
        for (newport = port; newport < port + 200; ++newport) {
            Socket socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(host, newport);
            try {
                socket.bind(address);
                int n = newport;
                return n;
            }
            catch (BindException e) {
                continue;
            }
            finally {
                socket.close();
            }
        }
        throw new WebDriverException(String.format("Cannot find free port in the range %d to %d ", port, newport));
    }

    public void quit() {
        try {
            this.sendMessage(new Command(null, "quit", new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.process.quit();
        this.profile.clean();
    }
}

