/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.Preferences;
import org.openqa.selenium.firefox.UnableToCreateProfileException;
import org.openqa.selenium.firefox.internal.ClasspathExtension;
import org.openqa.selenium.firefox.internal.Extension;
import org.openqa.selenium.firefox.internal.FileExtension;
import org.openqa.selenium.io.Cleanly;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxProfile {
    public static final String PORT_PREFERENCE = "webdriver_firefox_port";
    private static final ImmutableMap<String, Object> FROZEN_PREFERENCES = ImmutableMap.builder().put((Object)"app.update.auto", (Object)false).put((Object)"app.update.enabled", (Object)false).put((Object)"browser.download.manager.showWhenStarting", (Object)false).put((Object)"browser.EULA.override", (Object)true).put((Object)"browser.EULA.3.accepted", (Object)true).put((Object)"browser.link.open_external", (Object)2).put((Object)"browser.link.open_newwindow", (Object)2).put((Object)"browser.offline", (Object)false).put((Object)"browser.safebrowsing.enabled", (Object)false).put((Object)"browser.search.update", (Object)false).put((Object)"browser.sessionstore.resume_from_crash", (Object)false).put((Object)"browser.shell.checkDefaultBrowser", (Object)false).put((Object)"browser.tabs.warnOnClose", (Object)false).put((Object)"browser.tabs.warnOnOpen", (Object)false).put((Object)"devtools.errorconsole.enabled", (Object)true).put((Object)"dom.disable_open_during_load", (Object)false).put((Object)"extensions.logging.enabled", (Object)true).put((Object)"extensions.update.enabled", (Object)false).put((Object)"extensions.update.notifyUser", (Object)false).put((Object)"network.manage-offline-status", (Object)false).put((Object)"network.http.max-connections-per-server", (Object)10).put((Object)"prompts.tab_modal.enabled", (Object)false).put((Object)"security.fileuri.origin_policy", (Object)3).put((Object)"security.fileuri.strict_origin_policy", (Object)false).put((Object)"security.warn_entering_secure", (Object)false).put((Object)"security.warn_entering_secure.show_once", (Object)false).put((Object)"security.warn_entering_weak", (Object)false).put((Object)"security.warn_entering_weak.show_once", (Object)false).put((Object)"security.warn_leaving_secure", (Object)false).put((Object)"security.warn_leaving_secure.show_once", (Object)false).put((Object)"security.warn_submit_insecure", (Object)false).put((Object)"security.warn_viewing_mixed", (Object)false).put((Object)"security.warn_viewing_mixed.show_once", (Object)false).put((Object)"signon.rememberSignons", (Object)false).put((Object)"toolkit.networkmanager.disable", (Object)true).build();
    private static final String MAX_SCRIPT_RUN_TIME_KEY = "dom.max_script_run_time";
    private static final int DEFAULT_MAX_SCRIPT_RUN_TIME = 30;
    private Preferences additionalPrefs = new Preferences(){
        {
            this.setPreference(FirefoxProfile.MAX_SCRIPT_RUN_TIME_KEY, 30);
        }
    };
    private Map<String, Extension> extensions = Maps.newHashMap();
    private boolean enableNativeEvents;
    private boolean loadNoFocusLib;
    private boolean acceptUntrustedCerts;
    private boolean untrustedCertIssuer;
    private File model;
    private static final String ENABLE_NATIVE_EVENTS_PREF = "webdriver_enable_native_events";
    private static final String ACCEPT_UNTRUSTED_CERTS_PREF = "webdriver_accept_untrusted_certs";
    private static final String ASSUME_UNTRUSTED_ISSUER_PREF = "webdriver_assume_untrusted_issuer";

    public FirefoxProfile() {
        this(null);
    }

    public FirefoxProfile(File profileDir) {
        this.model = profileDir;
        this.verifyModel(this.model);
        File prefsInModel = new File(this.model, "user.js");
        if (prefsInModel.exists()) {
            Preferences existingPrefs = new Preferences(prefsInModel);
            this.enableNativeEvents = this.getBooleanPreference(existingPrefs, ENABLE_NATIVE_EVENTS_PREF, FirefoxDriver.DEFAULT_ENABLE_NATIVE_EVENTS);
            this.acceptUntrustedCerts = this.getBooleanPreference(existingPrefs, ACCEPT_UNTRUSTED_CERTS_PREF, true);
            this.untrustedCertIssuer = this.getBooleanPreference(existingPrefs, ASSUME_UNTRUSTED_ISSUER_PREF, true);
        } else {
            this.enableNativeEvents = FirefoxDriver.DEFAULT_ENABLE_NATIVE_EVENTS;
            this.acceptUntrustedCerts = true;
            this.untrustedCertIssuer = true;
        }
        this.loadNoFocusLib = false;
    }

    private boolean getBooleanPreference(Preferences prefs, String key, boolean defaultValue) {
        Object value = prefs.getPreference(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new WebDriverException("Expected boolean value is not a boolean. It is: " + value);
    }

    private void verifyModel(File model) {
        if (model == null) {
            return;
        }
        if (!model.exists()) {
            throw new UnableToCreateProfileException("Given model profile directory does not exist: " + model.getPath());
        }
        if (!model.isDirectory()) {
            throw new UnableToCreateProfileException("Given model profile directory is not a directory: " + model.getAbsolutePath());
        }
    }

    protected void addWebDriverExtensionIfNeeded() {
        if (this.extensions.containsKey("webdriver")) {
            return;
        }
        ClasspathExtension extension = new ClasspathExtension(FirefoxProfile.class, "/" + this.getClass().getPackage().getName().replace(".", "/") + "/webdriver.xpi");
        this.addExtension("webdriver", extension);
    }

    public void addExtension(Class<?> loadResourcesUsing, String loadFrom) throws IOException {
        File file = new File(loadFrom);
        if (file.exists()) {
            this.addExtension(file);
            return;
        }
        this.addExtension(loadFrom, new ClasspathExtension(loadResourcesUsing, loadFrom));
    }

    public void addExtension(File extensionToInstall) throws IOException {
        this.addExtension(extensionToInstall.getName(), new FileExtension(extensionToInstall));
    }

    protected void addExtension(String key, Extension extension) {
        String name = this.deriveExtensionName(key);
        this.extensions.put(name, extension);
    }

    private String deriveExtensionName(String originalName) {
        String[] pieces = originalName.replace('\\', '/').split("/");
        String name = pieces[pieces.length - 1];
        name = name.replaceAll("\\..*?$", "");
        return name;
    }

    public void setPreference(String key, String value) {
        FirefoxProfile.checkPreference(key, value);
        this.additionalPrefs.setPreference(key, value);
    }

    public void setPreference(String key, boolean value) {
        FirefoxProfile.checkPreference(key, value);
        this.additionalPrefs.setPreference(key, value);
    }

    public void setPreference(String key, int value) {
        FirefoxProfile.checkPreference(key, value);
        this.additionalPrefs.setPreference(key, value);
    }

    private static void checkPreference(String key, Object value) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((!FROZEN_PREFERENCES.containsKey((Object)key) ? 1 : 0) != 0, (String)"Preference %s may not be overridden: frozen value=%s, requested value=%s", (Object[])new Object[]{key, FROZEN_PREFERENCES.get((Object)key), value});
        if (MAX_SCRIPT_RUN_TIME_KEY.equals(key)) {
            int n;
            if (value instanceof String) {
                n = Integer.parseInt((String)value);
            } else if (value instanceof Integer) {
                n = (Integer)value;
            } else {
                throw new IllegalArgumentException(String.format("%s value must be a number: %s", MAX_SCRIPT_RUN_TIME_KEY, value.getClass().getName()));
            }
            Preconditions.checkArgument((n == 0 || n >= 30 ? 1 : 0) != 0, (String)"%s must be == 0 || >= %s", (Object[])new Object[]{MAX_SCRIPT_RUN_TIME_KEY, 30});
        }
    }

    public FirefoxProfile setProxyPreferences(Proxy proxy) {
        if (proxy.getProxyType() == Proxy.ProxyType.UNSPECIFIED) {
            return this;
        }
        this.setPreference("network.proxy.type", proxy.getProxyType().ordinal());
        switch (proxy.getProxyType()) {
            case MANUAL: {
                this.setPreference("network.proxy.no_proxies_on", "");
                this.setManualProxyPreference("ftp", proxy.getFtpProxy());
                this.setManualProxyPreference("http", proxy.getHttpProxy());
                this.setManualProxyPreference("ssl", proxy.getSslProxy());
                if (proxy.getNoProxy() == null) break;
                this.setPreference("network.proxy.no_proxies_on", proxy.getNoProxy());
                break;
            }
            case PAC: {
                this.setPreference("network.proxy.autoconfig_url", proxy.getProxyAutoconfigUrl());
            }
        }
        return this;
    }

    private void setManualProxyPreference(String key, String settingString) {
        if (settingString == null) {
            return;
        }
        String[] hostPort = settingString.split(":");
        this.setPreference("network.proxy." + key, hostPort[0]);
        if (hostPort.length > 1) {
            this.setPreference("network.proxy." + key + "_port", Integer.parseInt(hostPort[1]));
        }
    }

    protected Preferences getAdditionalPreferences() {
        return this.additionalPrefs;
    }

    public void updateUserPrefs(File userPrefs) {
        Preferences prefs = new Preferences();
        prefs.setPreference("browser.startup.homepage", "about:blank");
        prefs.setPreference("browser.startup.page", 0);
        if (userPrefs.exists()) {
            prefs = new Preferences(userPrefs);
            if (!userPrefs.delete()) {
                throw new WebDriverException("Cannot delete existing user preferences");
            }
        }
        this.additionalPrefs.addTo(prefs);
        prefs.putAll((Map<String, Object>)FROZEN_PREFERENCES);
        prefs.setPreference(ENABLE_NATIVE_EVENTS_PREF, this.enableNativeEvents);
        prefs.setPreference(ACCEPT_UNTRUSTED_CERTS_PREF, this.acceptUntrustedCerts);
        prefs.setPreference(ASSUME_UNTRUSTED_ISSUER_PREF, this.untrustedCertIssuer);
        prefs.setPreference("javascript.options.showInConsole", true);
        prefs.setPreference("browser.dom.window.dump.enabled", true);
        prefs.setPreference("dom.report_all_js_exceptions", true);
        Object homePage = prefs.getPreference("browser.startup.homepage");
        if (homePage != null && homePage instanceof String) {
            prefs.setPreference("startup.homepage_welcome_url", (String)homePage);
        }
        if (!"about:blank".equals(prefs.getPreference("browser.startup.homepage"))) {
            prefs.setPreference("browser.startup.page", 1);
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(userPrefs);
            prefs.writeTo(writer);
        }
        catch (IOException e) {
            try {
                throw new WebDriverException((Throwable)e);
            }
            catch (Throwable throwable) {
                Cleanly.close(writer);
                throw throwable;
            }
        }
        Cleanly.close((Writer)writer);
    }

    protected void deleteLockFiles(File profileDir) {
        File macAndLinuxLockFile = new File(profileDir, ".parentlock");
        File windowsLockFile = new File(profileDir, "parent.lock");
        macAndLinuxLockFile.delete();
        windowsLockFile.delete();
    }

    public void deleteExtensionsCacheIfItExists(File profileDir) {
        File cacheFile = new File(profileDir, "extensions.cache");
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
    }

    public boolean enableNativeEvents() {
        return this.enableNativeEvents;
    }

    public void setEnableNativeEvents(boolean enableNativeEvents) {
        this.enableNativeEvents = enableNativeEvents;
    }

    public boolean alwaysLoadNoFocusLib() {
        return this.loadNoFocusLib;
    }

    public void setAlwaysLoadNoFocusLib(boolean loadNoFocusLib) {
        this.loadNoFocusLib = loadNoFocusLib;
    }

    public void setAcceptUntrustedCertificates(boolean acceptUntrustedSsl) {
        this.acceptUntrustedCerts = acceptUntrustedSsl;
    }

    public void setAssumeUntrustedCertificateIssuer(boolean untrustedIssuer) {
        this.untrustedCertIssuer = untrustedIssuer;
    }

    public boolean isRunning(File profileDir) {
        File macAndLinuxLockFile = new File(profileDir, ".parentlock");
        File windowsLockFile = new File(profileDir, "parent.lock");
        return macAndLinuxLockFile.exists() || windowsLockFile.exists();
    }

    public void clean(File profileDir) {
        TemporaryFilesystem.getDefaultTmpFS().deleteTempDir(profileDir);
    }

    public String toJson() throws IOException {
        File generatedProfile = this.layoutOnDisk();
        return new Zip().zip(generatedProfile);
    }

    public static FirefoxProfile fromJson(String json) throws IOException {
        File dir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("webdriver", "duplicated");
        new Zip().unzip(json, dir);
        return new FirefoxProfile(dir);
    }

    public File layoutOnDisk() {
        try {
            File profileDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("anonymous", "webdriver-profile");
            File userPrefs = new File(profileDir, "user.js");
            this.copyModel(this.model, profileDir);
            this.installExtensions(profileDir);
            this.deleteLockFiles(profileDir);
            this.deleteExtensionsCacheIfItExists(profileDir);
            this.updateUserPrefs(userPrefs);
            return profileDir;
        }
        catch (IOException e) {
            throw new UnableToCreateProfileException(e);
        }
    }

    protected void copyModel(File sourceDir, File profileDir) throws IOException {
        if (sourceDir == null || !sourceDir.exists()) {
            return;
        }
        FileUtils.copyDirectory((File)sourceDir, (File)profileDir);
    }

    protected void installExtensions(File parentDir) throws IOException {
        File extensionsDir = new File(parentDir, "extensions");
        for (Extension extension : this.extensions.values()) {
            extension.writeTo(extensionsDir);
        }
    }
}

