/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.NotConnectedException;
import org.openqa.selenium.firefox.internal.ClasspathExtension;
import org.openqa.selenium.internal.Lock;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.internal.CircularOutputStream;

public class NewProfileExtensionConnection
implements ExtensionConnection,
NeedsLocalLogs {
    private static final int BUFFER_SIZE = 4096;
    private static final NetworkUtils networkUtils = new NetworkUtils();
    private final long connectTimeout;
    private final FirefoxBinary process;
    private final FirefoxProfile profile;
    private final String host;
    private final Lock lock;
    private File profileDir;
    private HttpCommandExecutor delegate;
    private LocalLogs logs = LocalLogs.getNullLogger();

    public NewProfileExtensionConnection(Lock lock, FirefoxBinary binary, FirefoxProfile profile, String host) throws Exception {
        this.host = host;
        this.connectTimeout = binary.getTimeout();
        this.lock = lock;
        this.profile = profile;
        this.process = binary;
    }

    @Override
    public void start() throws IOException {
        this.addWebDriverExtensionIfNeeded();
        int port = 0;
        this.lock.lock(this.connectTimeout);
        try {
            port = this.determineNextFreePort(7055);
            this.profile.setPreference("webdriver_firefox_port", port);
            this.profileDir = this.profile.layoutOnDisk();
            this.process.clean(this.profile, this.profileDir);
            this.delegate = new HttpCommandExecutor(NewProfileExtensionConnection.buildUrl(this.host, port));
            this.delegate.setLocalLogs(this.logs);
            String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
            if (firefoxLogFile != null) {
                if ("/dev/stdout".equals(firefoxLogFile)) {
                    this.process.setOutputWatcher(System.out);
                } else {
                    File logFile = new File(firefoxLogFile);
                    this.process.setOutputWatcher((OutputStream)new CircularOutputStream(logFile, 4096));
                }
            }
            this.process.startProfile(this.profile, this.profileDir, "-foreground");
            long waitUntil = System.currentTimeMillis() + this.connectTimeout;
            while (!this.isConnected()) {
                if (waitUntil < System.currentTimeMillis()) {
                    throw new NotConnectedException(this.delegate.getAddressOfRemoteServer(), this.connectTimeout, this.process.getConsoleOutput());
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignored) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new WebDriverException(String.format("Failed to connect to binary %s on port %d; process output follows: \n%s", this.process.toString(), port, this.process.getConsoleOutput()), (Throwable)e);
        }
        catch (WebDriverException e) {
            throw new WebDriverException(String.format("Failed to connect to binary %s on port %d; process output follows: \n%s", this.process.toString(), port, this.process.getConsoleOutput()), (Throwable)e);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void addWebDriverExtensionIfNeeded() {
        if (this.profile.containsWebDriverExtension()) {
            return;
        }
        ClasspathExtension extension = new ClasspathExtension(FirefoxProfile.class, "/" + FirefoxProfile.class.getPackage().getName().replace(".", "/") + "/webdriver.xpi");
        this.profile.addExtension("webdriver", extension);
    }

    public Response execute(Command command) throws IOException {
        return this.delegate.execute(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int determineNextFreePort(int port) {
        int newport;
        for (newport = port; newport < port + 2000; ++newport) {
            Socket socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(networkUtils.obtainLoopbackIp4Address(), newport);
            try {
                socket.bind(address);
                int n = newport;
                return n;
            }
            catch (IOException e) {
                continue;
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException ignored) {}
            }
        }
        throw new WebDriverException(String.format("Cannot find free port in the range %d to %d ", port, newport));
    }

    @Override
    public void quit() {
        this.process.quit();
        if (this.profileDir != null) {
            this.profile.clean(this.profileDir);
        }
    }

    private static URL buildUrl(String host, int port) {
        String hostToUse = "localhost".equals(host) ? networkUtils.obtainLoopbackIp4Address() : host;
        try {
            return new URL("http", hostToUse, port, "/hub");
        }
        catch (MalformedURLException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    @Override
    public boolean isConnected() {
        try {
            this.delegate.getAddressOfRemoteServer().openConnection().connect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void setLocalLogs(LocalLogs logs) {
        if (this.delegate != null) {
            this.delegate.setLocalLogs(logs);
        }
        this.logs = logs;
    }
}

