/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;

public class GeckoDriverService
extends DriverService {
    public static final String GECKO_DRIVER_EXE_PROPERTY = "webdriver.gecko.driver";

    public GeckoDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static GeckoDriverService createDefaultService() {
        return (GeckoDriverService)new Builder().build();
    }

    static GeckoDriverService createDefaultService(Capabilities caps) {
        Builder builder = new Builder();
        Object binary = caps.getCapability("firefox_binary");
        if (binary != null) {
            FirefoxBinary actualBinary;
            if (binary instanceof FirefoxBinary) {
                actualBinary = (FirefoxBinary)binary;
            } else if (binary instanceof String) {
                actualBinary = new FirefoxBinary(new File(String.valueOf(binary)));
            } else {
                throw new IllegalArgumentException("Expected binary to be a string or a binary: " + binary);
            }
            builder.usingFirefoxBinary(actualBinary);
        }
        return (GeckoDriverService)new Builder().build();
    }

    protected void waitUntilAvailable() throws MalformedURLException {
        PortProber.waitForPortUp((int)this.getUrl().getPort(), (int)20, (TimeUnit)TimeUnit.SECONDS);
    }

    protected boolean hasShutdownEndpoint() {
        return false;
    }

    public static class Builder
    extends DriverService.Builder<GeckoDriverService, Builder> {
        private FirefoxBinary firefoxBinary;

        public Builder() {
        }

        @Deprecated
        public Builder(FirefoxBinary binary) {
            this.firefoxBinary = binary;
        }

        public Builder usingFirefoxBinary(FirefoxBinary firefoxBinary) {
            Preconditions.checkNotNull((Object)firefoxBinary);
            GeckoDriverService.checkExecutable((File)firefoxBinary.getFile());
            this.firefoxBinary = firefoxBinary;
            return this;
        }

        protected File findDefaultExecutable() {
            return GeckoDriverService.findExecutable((String)"geckodriver", (String)GeckoDriverService.GECKO_DRIVER_EXE_PROPERTY, (String)"https://github.com/mozilla/geckodriver", (String)"https://github.com/mozilla/geckodriver/releases");
        }

        protected ImmutableList<String> createArgs() {
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            argsBuilder.add((Object)String.format("--port=%d", this.getPort()));
            if (this.firefoxBinary != null) {
                argsBuilder.add((Object)"-b");
                argsBuilder.add((Object)this.firefoxBinary.getPath());
            }
            return argsBuilder.build();
        }

        protected GeckoDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                GeckoDriverService service = new GeckoDriverService(exe, port, args, environment);
                String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
                if (firefoxLogFile != null) {
                    if ("/dev/stdout".equals(firefoxLogFile)) {
                        service.sendOutputTo(System.out);
                    } else if ("/dev/stderr".equals(firefoxLogFile)) {
                        service.sendOutputTo(System.err);
                    } else if ("/dev/null".equals(firefoxLogFile)) {
                        service.sendOutputTo(ByteStreams.nullOutputStream());
                    } else {
                        service.sendOutputTo(new FileOutputStream(firefoxLogFile));
                    }
                } else if (this.getLogFile() != null) {
                    service.sendOutputTo(new FileOutputStream(this.getLogFile()));
                } else {
                    service.sendOutputTo(System.err);
                }
                return service;
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

