/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.NetworkInterface;
import org.openqa.selenium.net.NetworkInterfaceProvider;

public class DefaultNetworkInterfaceProvider
implements NetworkInterfaceProvider {
    private final List<NetworkInterface> cachedInterfaces;

    @Override
    public Iterable<NetworkInterface> getNetworkInterfaces() {
        return this.cachedInterfaces;
    }

    public DefaultNetworkInterfaceProvider() {
        Enumeration<java.net.NetworkInterface> interfaces = null;
        try {
            interfaces = java.net.NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new WebDriverException((Throwable)e);
        }
        ArrayList<NetworkInterface> result = new ArrayList<NetworkInterface>();
        while (interfaces.hasMoreElements()) {
            result.add(this.createInterface(interfaces.nextElement()));
        }
        this.cachedInterfaces = Collections.unmodifiableList(result);
    }

    private String getLocalInterfaceName() {
        if (Platform.getCurrent().is(Platform.MAC)) {
            return "lo0";
        }
        return "lo";
    }

    @Override
    public NetworkInterface getLoInterface() {
        String localIF = this.getLocalInterfaceName();
        try {
            java.net.NetworkInterface byName = java.net.NetworkInterface.getByName(localIF);
            return byName != null ? this.createInterface(byName) : null;
        }
        catch (SocketException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private NetworkInterface createInterface(java.net.NetworkInterface s) {
        return new NetworkInterface(s);
    }
}

