/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.util.Objects;
import org.openqa.selenium.bidi.browsingcontext.NavigationInfo;
import org.openqa.selenium.json.JsonInput;

public class DownloadCanceled
extends NavigationInfo {
    private final String status;
    private static final String CANCELED = "canceled";

    DownloadCanceled(String browsingContextId, String navigationId, long timestamp, String url, String status) {
        super(browsingContextId, navigationId, timestamp, url);
        this.status = Objects.requireNonNullElse(status, CANCELED);
    }

    public static DownloadCanceled fromJson(JsonInput input) {
        String browsingContextId = null;
        String navigationId = null;
        long timestamp = 0L;
        String url = null;
        String status = CANCELED;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "context": {
                    browsingContextId = (String)input.read(String.class);
                    continue block14;
                }
                case "navigation": {
                    navigationId = (String)input.read(String.class);
                    continue block14;
                }
                case "timestamp": {
                    timestamp = (Long)input.read(Long.class);
                    continue block14;
                }
                case "url": {
                    url = (String)input.read(String.class);
                    continue block14;
                }
                case "status": {
                    status = (String)input.read(String.class);
                    if (CANCELED.equals(status)) continue block14;
                    throw new IllegalArgumentException("Expected status 'canceled' , but got: " + status);
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DownloadCanceled(browsingContextId, navigationId, timestamp, url, status);
    }

    public String getStatus() {
        return this.status;
    }
}

