/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.json.JsonInput;

public class NavigationInfo {
    private final String browsingContextId;
    private final String navigationId;
    private final long timestamp;
    private final String url;

    protected NavigationInfo(String browsingContextId, String navigationId, long timestamp, String url) {
        this.browsingContextId = browsingContextId;
        this.navigationId = navigationId;
        this.timestamp = timestamp;
        this.url = url;
    }

    public static NavigationInfo fromJson(JsonInput input) {
        String browsingContextId = null;
        String navigationId = null;
        long timestamp = 0L;
        String url = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "context": {
                    browsingContextId = (String)input.read(String.class);
                    continue block12;
                }
                case "navigation": {
                    navigationId = (String)input.read(String.class);
                    continue block12;
                }
                case "timestamp": {
                    timestamp = (Long)input.read(Long.class);
                    continue block12;
                }
                case "url": {
                    url = (String)input.read(String.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NavigationInfo(browsingContextId, navigationId, timestamp, url);
    }

    public String getBrowsingContextId() {
        return this.browsingContextId;
    }

    public String getNavigationId() {
        return this.navigationId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUrl() {
        return this.url;
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("browsingContextId", this.getBrowsingContextId());
        toReturn.put("navigationId", this.getNavigationId());
        toReturn.put("timestamp", this.getTimestamp());
        toReturn.put("url", this.getUrl());
        return Collections.unmodifiableMap(toReturn);
    }
}

