/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SafariOptions {
    public static final String CAPABILITY = "safari.options";
    private int port = 0;
    private boolean useCleanSession = false;

    public static SafariOptions fromCapabilities(Capabilities capabilities) throws WebDriverException {
        Object cap = capabilities.getCapability(CAPABILITY);
        if (cap instanceof SafariOptions) {
            return (SafariOptions)cap;
        }
        if (cap instanceof Map) {
            try {
                return SafariOptions.fromJsonMap((Map)cap);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        return new SafariOptions();
    }

    public void addExtensions(File ... paths) {
    }

    public void addExtensions(List<File> paths) {
    }

    public void setDataDir(File dataDir) {
    }

    public void setDriverExtension(File driverExtension) {
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSkipExtensionInstallation(boolean skipExtensionInstallation) {
    }

    public void setUseCleanSession(boolean useCleanSession) {
        this.useCleanSession = useCleanSession;
    }

    public Optional<File> getDataDir() {
        return Optional.absent();
    }

    public List<File> getExtensions() {
        return ImmutableList.of();
    }

    public int getPort() {
        return this.port;
    }

    public boolean getSkipExtensionInstallation() {
        return false;
    }

    public boolean getUseCustomDriverExtension() {
        return false;
    }

    public boolean getUseCleanSession() {
        return this.useCleanSession;
    }

    public JsonObject toJson() throws IOException {
        JsonObject options = new JsonObject();
        options.addProperty("port", (Number)this.port);
        options.addProperty("cleanSession", Boolean.valueOf(this.useCleanSession));
        return options;
    }

    private static SafariOptions fromJsonMap(Map options) throws IOException {
        Boolean useCleanSession;
        SafariOptions safariOptions = new SafariOptions();
        Number port = (Number)options.get("port");
        if (port != null) {
            safariOptions.setPort(port.intValue());
        }
        if ((useCleanSession = (Boolean)options.get("cleanSession")) != null) {
            safariOptions.setUseCleanSession(useCleanSession);
        }
        return safariOptions;
    }

    DesiredCapabilities toCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.safari();
        capabilities.setCapability(CAPABILITY, (Object)this);
        return capabilities;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SafariOptions)) {
            return false;
        }
        SafariOptions that = (SafariOptions)other;
        return this.port == that.port && this.useCleanSession == that.useCleanSession;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.port, this.useCleanSession});
    }

    private static class Option {
        private static final String CLEAN_SESSION = "cleanSession";
        private static final String PORT = "port";

        private Option() {
        }
    }
}

