/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.PKIXPolicyNode;

public class CertPathValidatorUtilities {
    protected static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    protected static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    protected static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    protected static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    protected static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    protected static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    protected static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    protected static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    protected static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    protected static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    protected static final String ANY_POLICY = "2.5.29.32.0";
    protected static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    protected static final int KEY_CERT_SIGN = 5;
    protected static final int CRL_SIGN = 6;
    protected static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    protected static final TrustAnchor findTrustAnchor(X509Certificate x509Certificate, CertPath certPath, int n, Set set) throws CertPathValidatorException {
        Iterator iterator = set.iterator();
        TrustAnchor trustAnchor = null;
        PublicKey publicKey = null;
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(CertPathValidatorUtilities.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException(iOException);
        }
        while (iterator.hasNext() && trustAnchor == null) {
            block15: {
                trustAnchor = (TrustAnchor)iterator.next();
                if (trustAnchor.getTrustedCert() != null) {
                    if (x509CertSelector.match(trustAnchor.getTrustedCert())) {
                        publicKey = trustAnchor.getTrustedCert().getPublicKey();
                    } else {
                        trustAnchor = null;
                    }
                } else if (trustAnchor.getCAName() != null && trustAnchor.getCAPublicKey() != null) {
                    try {
                        X500Principal x500Principal = CertPathValidatorUtilities.getEncodedIssuerPrincipal(x509Certificate);
                        X500Principal x500Principal2 = new X500Principal(trustAnchor.getCAName());
                        if (x500Principal.equals(x500Principal2)) {
                            publicKey = trustAnchor.getCAPublicKey();
                            break block15;
                        }
                        trustAnchor = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        trustAnchor = null;
                    }
                } else {
                    trustAnchor = null;
                }
            }
            if (publicKey == null) continue;
            try {
                x509Certificate.verify(publicKey);
            }
            catch (Exception exception2) {
                exception = exception2;
                trustAnchor = null;
            }
        }
        if (trustAnchor == null && exception != null) {
            throw new CertPathValidatorException("TrustAnchor found but certificate validation failed.", exception, certPath, n);
        }
        return trustAnchor;
    }

    protected static X500Principal getEncodedIssuerPrincipal(X509Certificate x509Certificate) {
        return x509Certificate.getIssuerX500Principal();
    }

    protected static Date getValidDate(PKIXParameters pKIXParameters) {
        Date date = pKIXParameters.getDate();
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    protected static X500Principal getSubjectPrincipal(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectX500Principal();
    }

    protected static boolean isSelfIssued(X509Certificate x509Certificate) {
        return ((Object)x509Certificate.getSubjectDN()).equals(x509Certificate.getIssuerDN());
    }

    protected static DERObject getExtensionValue(X509Extension x509Extension, String string) throws AnnotatedException {
        byte[] byArray = x509Extension.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        return CertPathValidatorUtilities.getObject(string, byArray);
    }

    private static DERObject getObject(String string, byte[] byArray) throws AnnotatedException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            aSN1InputStream = new ASN1InputStream(aSN1OctetString.getOctets());
            return aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new AnnotatedException("exception processing extension " + string, iOException);
        }
    }

    protected static X500Principal getIssuerPrincipal(X509CRL x509CRL) {
        return x509CRL.getIssuerX500Principal();
    }

    protected static AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(publicKey.getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            return subjectPublicKeyInfo.getAlgorithmId();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing public key");
        }
    }

    private static boolean withinDNSubtree(ASN1Sequence aSN1Sequence, ASN1Sequence aSN1Sequence2) {
        if (aSN1Sequence2.size() < 1) {
            return false;
        }
        if (aSN1Sequence2.size() > aSN1Sequence.size()) {
            return false;
        }
        for (int i = aSN1Sequence2.size() - 1; i >= 0; --i) {
            if (aSN1Sequence2.getObjectAt(i).equals(aSN1Sequence.getObjectAt(i))) continue;
            return false;
        }
        return true;
    }

    protected static void checkPermittedDN(Set set, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (!CertPathValidatorUtilities.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    protected static void checkExcludedDN(Set set, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (!CertPathValidatorUtilities.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            throw new CertPathValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    protected static Set intersectDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (CertPathValidatorUtilities.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            if (!CertPathValidatorUtilities.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) continue;
            hashSet.add(aSN1Sequence2);
        }
        return hashSet;
    }

    protected static Set unionDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (CertPathValidatorUtilities.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence2);
                continue;
            }
            if (CertPathValidatorUtilities.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            hashSet.add(aSN1Sequence2);
            hashSet.add(aSN1Sequence);
        }
        return hashSet;
    }

    protected static Set intersectEmail(Set set, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (set.isEmpty()) {
            set.add(string2);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : set) {
            if (string2.endsWith(string3)) {
                hashSet.add(string2);
                continue;
            }
            if (!string3.endsWith(string2)) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    protected static Set unionEmail(Set set, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (set.isEmpty()) {
            set.add(string2);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : set) {
            if (string2.endsWith(string3)) {
                hashSet.add(string3);
                continue;
            }
            if (string3.endsWith(string2)) {
                hashSet.add(string2);
                continue;
            }
            hashSet.add(string3);
            hashSet.add(string2);
        }
        return hashSet;
    }

    protected static Set intersectIP(Set set, byte[] byArray) {
        return set;
    }

    protected static Set unionIP(Set set, byte[] byArray) {
        return set;
    }

    protected static void checkPermittedEmail(Set set, String string) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        for (String string3 : set) {
            if (!string2.endsWith(string3)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject email address is not from a permitted subtree");
    }

    protected static void checkExcludedEmail(Set set, String string) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        for (String string3 : set) {
            if (!string2.endsWith(string3)) continue;
            throw new CertPathValidatorException("Subject email address is from an excluded subtree");
        }
    }

    protected static void checkPermittedIP(Set set, byte[] byArray) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
    }

    protected static void checkExcludedIP(Set set, byte[] byArray) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
    }

    protected static final Collection findCRLs(X509CRLSelector x509CRLSelector, List list) throws AnnotatedException {
        HashSet<? extends CRL> hashSet = new HashSet<CRL>();
        for (CertStore certStore : list) {
            try {
                hashSet.addAll(certStore.getCRLs(x509CRLSelector));
            }
            catch (CertStoreException certStoreException) {
                throw new AnnotatedException("cannot extract crl: " + certStoreException, certStoreException);
            }
        }
        return hashSet;
    }

    protected static final Set getQualifierSet(ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> hashSet = new HashSet<PolicyQualifierInfo>();
        if (aSN1Sequence == null) {
            return hashSet;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                aSN1OutputStream.writeObject(enumeration.nextElement());
                hashSet.add(new PolicyQualifierInfo(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("exception building qualifier set: " + iOException);
            }
            byteArrayOutputStream.reset();
        }
        return hashSet;
    }

    protected static PKIXPolicyNode removePolicyNode(PKIXPolicyNode pKIXPolicyNode, List[] listArray, PKIXPolicyNode pKIXPolicyNode2) {
        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
        if (pKIXPolicyNode == null) {
            return null;
        }
        if (pKIXPolicyNode3 == null) {
            for (int i = 0; i < listArray.length; ++i) {
                listArray[i] = new ArrayList();
            }
            return null;
        }
        pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
        CertPathValidatorUtilities.removePolicyNodeRecurse(listArray, pKIXPolicyNode2);
        return pKIXPolicyNode;
    }

    private static void removePolicyNodeRecurse(List[] listArray, PKIXPolicyNode pKIXPolicyNode) {
        listArray[pKIXPolicyNode.getDepth()].remove(pKIXPolicyNode);
        if (pKIXPolicyNode.hasChildren()) {
            Iterator iterator = pKIXPolicyNode.getChildren();
            while (iterator.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
                CertPathValidatorUtilities.removePolicyNodeRecurse(listArray, pKIXPolicyNode2);
            }
        }
    }

    protected static boolean processCertD1i(int n, List[] listArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        List list = listArray[n - 1];
        for (int i = 0; i < list.size(); ++i) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(i);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (!set2.contains(dERObjectIdentifier.getId())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(dERObjectIdentifier.getId());
            PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
            pKIXPolicyNode.addChild(pKIXPolicyNode2);
            listArray[n].add(pKIXPolicyNode2);
            return true;
        }
        return false;
    }

    protected static void processCertD1ii(int n, List[] listArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        List list = listArray[n - 1];
        for (int i = 0; i < list.size(); ++i) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(i);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (!ANY_POLICY.equals(pKIXPolicyNode.getValidPolicy())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(dERObjectIdentifier.getId());
            PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
            pKIXPolicyNode.addChild(pKIXPolicyNode2);
            listArray[n].add(pKIXPolicyNode2);
            return;
        }
    }

    protected static void prepareNextCertB1(int n, List[] listArray, String string, Map map, X509Certificate x509Certificate) throws AnnotatedException, CertPathValidatorException {
        boolean bl = false;
        for (PKIXPolicyNode pKIXPolicyNode : listArray[n]) {
            if (!pKIXPolicyNode.getValidPolicy().equals(string)) continue;
            bl = true;
            pKIXPolicyNode.expectedPolicies = (Set)map.get(string);
            break;
        }
        if (!bl) {
            for (PKIXPolicyNode pKIXPolicyNode : listArray[n]) {
                PKIXPolicyNode pKIXPolicyNode2;
                if (!ANY_POLICY.equals(pKIXPolicyNode.getValidPolicy())) continue;
                Set set = null;
                ASN1Sequence aSN1Sequence = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(x509Certificate, CERTIFICATE_POLICIES);
                Enumeration enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    PolicyInformation policyInformation = PolicyInformation.getInstance(enumeration.nextElement());
                    if (!ANY_POLICY.equals(policyInformation.getPolicyIdentifier().getId())) continue;
                    set = CertPathValidatorUtilities.getQualifierSet(policyInformation.getPolicyQualifiers());
                    break;
                }
                boolean bl2 = false;
                if (x509Certificate.getCriticalExtensionOIDs() != null) {
                    bl2 = x509Certificate.getCriticalExtensionOIDs().contains(CERTIFICATE_POLICIES);
                }
                if (!ANY_POLICY.equals((pKIXPolicyNode2 = (PKIXPolicyNode)pKIXPolicyNode.getParent()).getValidPolicy())) break;
                PKIXPolicyNode pKIXPolicyNode3 = new PKIXPolicyNode(new ArrayList(), n, (Set)map.get(string), pKIXPolicyNode2, set, string, bl2);
                pKIXPolicyNode2.addChild(pKIXPolicyNode3);
                listArray[n].add(pKIXPolicyNode3);
                break;
            }
        }
    }

    protected static PKIXPolicyNode prepareNextCertB2(int n, List[] listArray, String string, PKIXPolicyNode pKIXPolicyNode) {
        Iterator iterator = listArray[n].iterator();
        while (iterator.hasNext()) {
            PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
            if (!pKIXPolicyNode2.getValidPolicy().equals(string)) continue;
            PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
            pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
            iterator.remove();
            for (int i = n - 1; i >= 0; --i) {
                PKIXPolicyNode pKIXPolicyNode4;
                List list = listArray[i];
                for (int j = 0; j < list.size() && ((pKIXPolicyNode4 = (PKIXPolicyNode)list.get(j)).hasChildren() || (pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode4)) != null); ++j) {
                }
            }
        }
        return pKIXPolicyNode;
    }

    protected static boolean isAnyPolicy(Set set) {
        return set == null || set.contains(ANY_POLICY) || set.isEmpty();
    }
}

