/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.i18n;

import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.bouncycastle.i18n.MissingEntryException;
import org.bouncycastle.i18n.filter.Filter;
import org.bouncycastle.i18n.filter.UntrustedInput;

public class LocalizedMessage {
    protected final String id;
    protected final String resource;
    protected Object[] arguments;
    protected Object[] filteredArguments;
    protected Filter filter = null;

    public LocalizedMessage(String string, String string2) throws NullPointerException {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = new Object[0];
        this.filteredArguments = this.arguments;
    }

    public LocalizedMessage(String string, String string2, Object[] objectArray) throws NullPointerException {
        if (string == null || string2 == null || objectArray == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = objectArray;
        this.filteredArguments = objectArray;
    }

    public String getEntry(String string, Locale locale, TimeZone timeZone) throws MissingEntryException {
        String string2 = this.id + "." + string;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.resource, locale);
            String string3 = resourceBundle.getString(string2);
            if (this.arguments == null || this.arguments.length == 0) {
                return string3;
            }
            return this.formatWithTimeZone(string3, this.filteredArguments, locale, timeZone);
        }
        catch (MissingResourceException missingResourceException) {
            throw new MissingEntryException("Can't find entry " + string2 + " in resource file " + this.resource + ".", this.resource, string2);
        }
    }

    protected String formatWithTimeZone(String string, Object[] objectArray, Locale locale, TimeZone timeZone) {
        MessageFormat messageFormat = new MessageFormat(" ");
        messageFormat.setLocale(locale);
        messageFormat.applyPattern(string);
        if (!timeZone.equals(TimeZone.getDefault())) {
            Format[] formatArray = messageFormat.getFormats();
            for (int i = 0; i < formatArray.length; ++i) {
                if (!(formatArray[i] instanceof DateFormat)) continue;
                DateFormat dateFormat = (DateFormat)formatArray[i];
                dateFormat.setTimeZone(timeZone);
                messageFormat.setFormat(i, dateFormat);
            }
        }
        return messageFormat.format(objectArray);
    }

    public void setFilter(Filter filter) {
        if (filter == null) {
            this.filteredArguments = this.arguments;
        } else if (!filter.equals(this.filter)) {
            this.filteredArguments = new Object[this.arguments.length];
            for (int i = 0; i < this.arguments.length; ++i) {
                this.filteredArguments[i] = this.arguments[i] instanceof UntrustedInput ? filter.doFilter(((UntrustedInput)this.arguments[i]).getString()) : this.arguments[i];
            }
        }
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String getId() {
        return this.id;
    }

    public String getResource() {
        return this.resource;
    }

    public Object[] getArguments() {
        return this.arguments;
    }
}

