/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.base;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticdesktop.aperture.accessor.base.AccessDataImpl;
import org.semanticdesktop.aperture.util.ArrayMap;
import org.semanticdesktop.aperture.util.SimpleSAXAdapter;
import org.semanticdesktop.aperture.util.SimpleSAXParser;
import org.semanticdesktop.aperture.util.XmlWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FileAccessData
extends AccessDataImpl {
    public static final String REFERRED_ID_TAG = "referredID";
    public static final String AGGREGATED_ID_TAG = "aggregatedID";
    private Logger log = LoggerFactory.getLogger(FileAccessData.class);
    private int autoSaveCounter;
    private int autoSaveInterval;
    private File dataFile;

    public FileAccessData() {
    }

    public FileAccessData(File file) {
        this.dataFile = file;
    }

    public FileAccessData(int n) {
        this.autoSaveInterval = n;
    }

    public FileAccessData(File file, int n) {
        this.dataFile = file;
        this.autoSaveInterval = n;
    }

    public void setDataFile(File file) {
        this.dataFile = file;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public int getAutoSaveInterval() {
        return this.autoSaveInterval;
    }

    public void setAutoSaveInterval(int n) {
        this.autoSaveInterval = n;
        this.autoSaveCounter = 0;
    }

    public void put(String string, String string2, String string3) {
        super.put(string, string2, string3);
        this.updateCounter();
    }

    public String get(String string, String string2) {
        this.updateCounter();
        return super.get(string, string2);
    }

    private void updateCounter() {
        if (this.autoSaveInterval > 0) {
            ++this.autoSaveCounter;
            if (this.autoSaveCounter == this.autoSaveInterval) {
                this.autoSaveCounter = 0;
                try {
                    this.store();
                }
                catch (IOException iOException) {
                    this.log.warn("Couldn't auto-save the FileAccessData instance", (Throwable)iOException);
                }
            }
        }
    }

    public void initialize() throws IOException {
        this.idMap = null;
        this.referredIDMap = null;
        this.aggregatedIDMap = null;
        super.initialize();
        if (this.dataFile != null && this.dataFile.exists()) {
            FileInputStream fileInputStream = new FileInputStream(this.dataFile);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(bufferedInputStream);
            this.read(gZIPInputStream);
            gZIPInputStream.close();
        }
    }

    public void store() throws IOException {
        if (this.dataFile != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(this.dataFile);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bufferedOutputStream);
            this.write(gZIPOutputStream);
            gZIPOutputStream.close();
        }
    }

    public void clear() throws IOException {
        super.clear();
        if (this.dataFile != null && this.dataFile.exists()) {
            this.dataFile.delete();
        }
    }

    private void read(InputStream inputStream) throws IOException {
        try {
            SimpleSAXParser simpleSAXParser = new SimpleSAXParser();
            AccessDataParser accessDataParser = new AccessDataParser();
            simpleSAXParser.setListener(accessDataParser);
            simpleSAXParser.parse(inputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException(parserConfigurationException.getMessage());
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException(sAXException.getMessage());
            iOException.initCause(sAXException);
            throw iOException;
        }
    }

    private void write(OutputStream outputStream) throws IOException {
        XmlWriter xmlWriter = new XmlWriter(outputStream);
        xmlWriter.setPrettyPrint(true);
        xmlWriter.startDocument();
        xmlWriter.setAttribute("version", 1);
        xmlWriter.startTag("scanresult");
        for (String string : this.idMap.keySet()) {
            if (string != null) {
                xmlWriter.setAttribute("id", string.toString());
                xmlWriter.startTag("dataobject");
                this.writeInfo(string, xmlWriter);
                xmlWriter.endTag("dataobject");
                continue;
            }
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("Cannot write null id");
        }
        xmlWriter.endTag("scanresult");
        xmlWriter.endDocument();
    }

    private void writeInfo(String string, XmlWriter xmlWriter) throws IOException {
        String string2;
        Object object;
        Object object2;
        Object object3;
        ArrayMap arrayMap = (ArrayMap)this.idMap.get(string);
        if (arrayMap != null) {
            object3 = arrayMap.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = (String)object2.getKey();
                string2 = (String)object2.getValue();
                xmlWriter.textElement((String)object, string2);
            }
        }
        if ((object3 = (Set)this.referredIDMap.get(string)) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                xmlWriter.textElement(REFERRED_ID_TAG, (String)object);
            }
        }
        if ((object2 = this.getAggregatedIDs(string)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                xmlWriter.textElement(AGGREGATED_ID_TAG, string2);
            }
        }
    }

    private class AccessDataParser
    extends SimpleSAXAdapter {
        private String dataObjectId;

        private AccessDataParser() {
        }

        public void startTag(String string, Map map, String string2) throws SAXException {
            block14: {
                if (string.equals("scanresult")) {
                    String string3 = (String)map.get("version");
                    if (string3 == null) {
                        throw new SAXException("Scan results file version missing");
                    }
                    try {
                        int n = Integer.parseInt(string3);
                        if (n != 1) {
                            throw new SAXException("Unsupported scan results file version: " + string3);
                        }
                        break block14;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXException("Illegal scan results file version: " + string3);
                    }
                }
                if (string.equals("dataobject")) {
                    this.dataObjectId = (String)map.get("id");
                } else if (string.equals(FileAccessData.REFERRED_ID_TAG)) {
                    String string4 = string2;
                    if (string4 != null && this.dataObjectId != null) {
                        FileAccessData.this.putReferredID(this.dataObjectId, string4);
                    }
                } else if (string.equals(FileAccessData.AGGREGATED_ID_TAG)) {
                    String string5 = string2;
                    if (string5 != null && this.dataObjectId != null) {
                        FileAccessData.this.putAggregatedID(this.dataObjectId, string5);
                    }
                } else if (this.dataObjectId != null) {
                    FileAccessData.this.put(this.dataObjectId, string, string2);
                }
            }
        }

        public void endTag(String string) {
            if (string.equals("dataobject")) {
                this.dataObjectId = null;
            }
        }
    }
}

