/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.html;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.util.HtmlParserUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.UriUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;

public class HtmlExtractor
implements Extractor {
    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        HtmlParserUtil.parse(inputStream, charset, new TextAndMetadataExtractor(rDFContainer));
    }

    private static class TextAndMetadataExtractor
    extends HtmlParserUtil.ContentExtractor {
        private RDFContainer container;

        public TextAndMetadataExtractor(RDFContainer rDFContainer) {
            this.container = rDFContainer;
        }

        public void finishedParsing() {
            this.container.add(RDF.type, (Node)NFO.HtmlDocument);
            this.container.add(NIE.plainTextContent, this.getText());
            Iterator iterator = this.getKeywords();
            while (iterator.hasNext()) {
                this.addProperty(NIE.keyword, (String)iterator.next());
            }
            this.addProperty(NIE.title, this.getTitle());
            this.addContactProperty(NCO.creator, this.getAuthor());
            this.addProperty(NIE.description, this.getDescription());
        }

        private void addContactProperty(URI uRI, String string) {
            if (string != null) {
                string = string.trim();
                Model model = this.container.getModel();
                Resource resource = UriUtil.generateRandomResource(model);
                model.addStatement(resource, RDF.type, (Node)NCO.Contact);
                model.addStatement(resource, NCO.fullname, string);
                this.container.add(uRI, (Node)resource);
            }
        }

        private void addProperty(URI uRI, String string) {
            if (string != null && (string = string.trim()).length() > 0) {
                this.container.add(uRI, string);
            }
        }
    }
}

