/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.mime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.mime.MailUtil;
import org.semanticdesktop.aperture.extractor.util.HtmlParserUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NMO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeExtractor
implements Extractor {
    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        try {
            String string2;
            MimeMessage mimeMessage = new MimeMessage(null, inputStream);
            rDFContainer.add(RDF.type, (Node)NMO.Email);
            StringBuilder stringBuilder = new StringBuilder(10000);
            this.processContent(mimeMessage.getContent(), stringBuilder);
            String string3 = stringBuilder.toString().trim();
            if (string3.length() > 0) {
                rDFContainer.add(NMO.plainTextMessageContent, string3);
            }
            if ((string2 = mimeMessage.getSubject()) != null && (string2 = string2.trim()).length() > 0) {
                rDFContainer.add(NMO.messageSubject, string2);
            }
            try {
                this.copyAddress(mimeMessage.getFrom(), NMO.from, rDFContainer);
            }
            catch (AddressException addressException) {
                // empty catch block
            }
            this.copyAddress(this.getRecipients(mimeMessage, Message.RecipientType.TO), NMO.to, rDFContainer);
            this.copyAddress(this.getRecipients(mimeMessage, Message.RecipientType.CC), NMO.cc, rDFContainer);
            this.copyAddress(this.getRecipients(mimeMessage, Message.RecipientType.BCC), NMO.bcc, rDFContainer);
            MailUtil.getDates((Message)mimeMessage, rDFContainer);
        }
        catch (MessagingException messagingException) {
            throw new ExtractorException(messagingException);
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
    }

    private void processContent(Object object, StringBuilder stringBuilder) throws MessagingException, IOException {
        if (object instanceof String) {
            stringBuilder.append(object);
            stringBuilder.append(' ');
        } else if (object instanceof BodyPart) {
            BodyPart bodyPart = (BodyPart)object;
            String string = bodyPart.getFileName();
            if (string != null) {
                try {
                    string = MimeUtility.decodeWord((String)string);
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                stringBuilder.append(string);
                stringBuilder.append(' ');
            }
            object = bodyPart.getContent();
            String string2 = bodyPart.getContentType();
            if (string2 != null && object instanceof String && (string2 = string2.toLowerCase()).indexOf("text/html") >= 0) {
                object = this.extractTextFromHtml((String)object);
            }
            this.processContent(object, stringBuilder);
        } else if (object instanceof Multipart) {
            ContentType contentType;
            Multipart multipart = (Multipart)object;
            String string = null;
            String string3 = multipart.getContentType();
            if (string3 != null && (string = (contentType = new ContentType(string3)).getSubType()) != null) {
                string = string.trim().toLowerCase();
            }
            if ("alternative".equals(string)) {
                this.handleAlternativePart(multipart, stringBuilder);
            } else if ("signed".equals(string)) {
                this.handleProtectedPart(multipart, 0, stringBuilder);
            } else if ("encrypted".equals(string)) {
                this.handleProtectedPart(multipart, 1, stringBuilder);
            } else {
                this.handleMixedPart(multipart, stringBuilder);
            }
        }
    }

    private void handleAlternativePart(Multipart multipart, StringBuilder stringBuilder) throws MessagingException, IOException {
        Object object;
        boolean bl = false;
        int n = this.getPartWithMimeType(multipart, "text/plain");
        if (n < 0) {
            n = this.getPartWithMimeType(multipart, "text/html");
            bl = true;
        }
        if (n >= 0 && (object = multipart.getBodyPart(n).getContent()) != null) {
            if (object instanceof String && bl) {
                object = this.extractTextFromHtml((String)object);
            }
            this.processContent(object, stringBuilder);
        }
    }

    private void handleMixedPart(Multipart multipart, StringBuilder stringBuilder) throws MessagingException, IOException {
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            this.processContent(multipart.getBodyPart(i), stringBuilder);
        }
    }

    private void handleProtectedPart(Multipart multipart, int n, StringBuilder stringBuilder) throws MessagingException, IOException {
        if (n < multipart.getCount()) {
            this.processContent(multipart.getBodyPart(n), stringBuilder);
        }
    }

    private int getPartWithMimeType(Multipart multipart, String string) throws MessagingException {
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            if (!string.equalsIgnoreCase(this.getMimeType((Part)bodyPart))) continue;
            return i;
        }
        return -1;
    }

    private String getMimeType(Part part) throws MessagingException {
        String string = part.getContentType();
        if (string != null) {
            ContentType contentType = new ContentType(string);
            return contentType.getBaseType();
        }
        return null;
    }

    private String extractTextFromHtml(String string) {
        HtmlParserUtil.ContentExtractor contentExtractor = new HtmlParserUtil.ContentExtractor();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        try {
            HtmlParserUtil.parse(byteArrayInputStream, null, contentExtractor);
        }
        catch (ExtractorException extractorException) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32768);
        this.append(stringBuilder, contentExtractor.getTitle());
        this.append(stringBuilder, contentExtractor.getAuthor());
        this.append(stringBuilder, contentExtractor.getDescription());
        Iterator iterator = contentExtractor.getKeywords();
        while (iterator.hasNext()) {
            this.append(stringBuilder, (String)iterator.next());
        }
        this.append(stringBuilder, contentExtractor.getText());
        return stringBuilder.toString();
    }

    private void append(StringBuilder stringBuilder, String string) {
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        }
    }

    private Address[] getRecipients(MimeMessage mimeMessage, Message.RecipientType recipientType) throws MessagingException {
        Address[] addressArray = null;
        try {
            addressArray = mimeMessage.getRecipients(recipientType);
        }
        catch (AddressException addressException) {
            // empty catch block
        }
        return addressArray;
    }

    private void copyAddress(Object object, URI uRI, RDFContainer rDFContainer) {
        try {
            if (object instanceof InternetAddress) {
                MailUtil.addAddressMetadata((InternetAddress)object, uRI, rDFContainer);
            } else if (object instanceof InternetAddress[]) {
                InternetAddress[] internetAddressArray = (InternetAddress[])object;
                for (int i = 0; i < internetAddressArray.length; ++i) {
                    MailUtil.addAddressMetadata(internetAddressArray[i], uRI, rDFContainer);
                }
            }
        }
        catch (ModelException modelException) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("ModelException while adding address metadata", (Throwable)modelException);
        }
    }
}

