/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.rdf.RDFContainer;

public class ThreadedExtractorWrapper
implements Extractor {
    private static final long MAX_PROCESSING_TIME_PER_MB = 10000L;
    private static final long MINIMUM_MAX_PROCESSING_TIME = 30000L;
    private static final long MAX_IDLE_READ_TIME = 30000L;
    private Extractor extractor;
    private boolean stopRequested;

    public ThreadedExtractorWrapper(Extractor extractor) {
        this.extractor = extractor;
        this.stopRequested = false;
    }

    public void stop() {
        this.stopRequested = true;
    }

    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        ExtractionStream extractionStream = new ExtractionStream(inputStream);
        ExtractionThread extractionThread = new ExtractionThread(uRI, extractionStream, charset, string, rDFContainer);
        extractionThread.start();
        while (true) {
            long l;
            if (extractionStream.allBytesRead()) {
                l = 10000L * (long)extractionStream.getTotalBytesRead() / 0x100000L;
                l = Math.max(l, 30000L);
            } else {
                l = 30000L;
            }
            if ((l -= System.currentTimeMillis() - extractionStream.getLastAccessTime()) <= 0L || !extractionThread.isAlive()) break;
            try {
                extractionThread.join(l);
            }
            catch (InterruptedException interruptedException) {
                throw new ExtractorException(interruptedException);
            }
        }
        if (extractionThread.isAlive()) {
            extractionThread.abortExtraction();
            throw new ExtractorException("Extractor aborted");
        }
        Exception exception = extractionThread.getException();
        if (exception != null) {
            if (exception instanceof ExtractorException) {
                throw (ExtractorException)exception;
            }
            throw (RuntimeException)exception;
        }
    }

    public static class ExtractionInterruptedException
    extends IOException {
        public ExtractionInterruptedException() {
            super("Extraction interrupted upon request");
        }
    }

    private class ExtractionStream
    extends FilterInputStream {
        private long lastAccessTime;
        private boolean allBytesRead;
        private int totalBytesRead;

        public ExtractionStream(InputStream inputStream) {
            super(inputStream);
            this.lastAccessTime = System.currentTimeMillis();
            this.allBytesRead = false;
            this.totalBytesRead = 0;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public boolean allBytesRead() {
            return this.allBytesRead;
        }

        public int getTotalBytesRead() {
            return this.totalBytesRead;
        }

        public int read() throws IOException {
            this.checkStopRequested();
            int n = super.read();
            if (n >= 0) {
                this.lastAccessTime = System.currentTimeMillis();
                ++this.totalBytesRead;
            } else {
                this.allBytesRead = true;
            }
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            this.checkStopRequested();
            int n = super.read(byArray);
            if (n >= 0) {
                this.lastAccessTime = System.currentTimeMillis();
                this.totalBytesRead += n;
            } else {
                this.allBytesRead = true;
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.checkStopRequested();
            int n3 = super.read(byArray, n, n2);
            if (n3 >= 0) {
                this.lastAccessTime = System.currentTimeMillis();
                this.totalBytesRead += n3;
            } else {
                this.allBytesRead = true;
            }
            return n3;
        }

        public void close() throws IOException {
            super.close();
            this.allBytesRead = true;
        }

        private void checkStopRequested() throws ExtractionInterruptedException {
            if (ThreadedExtractorWrapper.this.stopRequested) {
                throw new ExtractionInterruptedException();
            }
        }
    }

    private class ExtractionThread
    extends Thread {
        private URI id;
        private InputStream input;
        private Charset charset;
        private String mimeType;
        private RDFContainer result;
        private Exception exception;

        public ExtractionThread(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) {
            this.id = uRI;
            this.input = inputStream;
            this.charset = charset;
            this.mimeType = string;
            this.result = rDFContainer;
        }

        public void run() {
            try {
                ThreadedExtractorWrapper.this.extractor.extract(this.id, this.input, this.charset, this.mimeType, this.result);
            }
            catch (Exception exception) {
                this.exception = exception;
            }
        }

        public void abortExtraction() {
            this.interrupt();
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

