/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.opener.file;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.aperture.opener.DataOpener;
import org.semanticdesktop.aperture.util.OSUtils;

public class FileOpener
implements DataOpener {
    public void open(org.ontoware.rdf2go.model.node.URI uRI) throws IOException {
        if (OSUtils.isMac()) {
            this.macopen(uRI);
        } else if (OSUtils.isLinux()) {
            this.linuxopen(uRI);
        } else if (OSUtils.isWindows()) {
            this.windowsopen(uRI);
        } else {
            throw new IOException("Unsupported OS:" + System.getProperty("os.name"));
        }
    }

    private void macopen(org.ontoware.rdf2go.model.node.URI uRI) throws IOException {
        try {
            Class<?> clazz = Class.forName("com.apple.eio.FileManager");
            Method method = clazz.getMethod("openURL", String.class);
            method.invoke(null, uRI.toString());
        }
        catch (Exception exception) {
            throw new IOException("Could not open file: " + uRI + " - " + exception);
        }
    }

    private File URI2File(org.ontoware.rdf2go.model.node.URI uRI) throws IOException {
        File file;
        try {
            file = new File(new URI(uRI.toString()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException("Could not parse URI: " + uRI.toString() + " - " + uRISyntaxException);
        }
        return file;
    }

    private void windowsopen(org.ontoware.rdf2go.model.node.URI uRI) throws IOException {
        File file = this.URI2File(uRI);
        if (file.isDirectory()) {
            Runtime.getRuntime().exec(new String[]{"cmd", "/c", "explorer", file.toString()});
        } else {
            Runtime.getRuntime().exec(new String[]{"cmd", "/c", file.toString()});
        }
    }

    private void linuxopen(org.ontoware.rdf2go.model.node.URI uRI) throws IOException {
        File file = this.URI2File(uRI);
        if (System.getenv("DESKTOP_SESSION").toLowerCase().contains("kde")) {
            Runtime.getRuntime().exec(new String[]{"kfmclient", "exec", file.toString()});
        } else {
            Runtime.getRuntime().exec(new String[]{"gnome-open", uRI.toString()});
        }
    }

    public static void main(String[] stringArray) throws IOException {
        FileOpener fileOpener = new FileOpener();
        if (OSUtils.isMac()) {
            fileOpener.open(URIImpl.createURIWithoutChecking((String)"file:///Users/"));
            fileOpener.open(URIImpl.createURIWithoutChecking((String)"file:///Users/"));
        } else if (OSUtils.isWindows()) {
            fileOpener.open(URIImpl.createURIWithoutChecking((String)"file:/c:"));
            fileOpener.open(URIImpl.createURIWithoutChecking((String)"file:/c:/windows/win.ini"));
        } else if (OSUtils.isLinux()) {
            fileOpener.open(URIImpl.createURIWithoutChecking((String)"file:///tmp"));
            fileOpener.open(URIImpl.createURIWithoutChecking((String)"file:///etc/bash.bashrc"));
        } else {
            throw new Error("What weirdass OS are you running?");
        }
    }
}

