/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.vcard;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.ContactMarshaller;
import net.wimpi.pim.contact.io.ContactUnmarshaller;
import net.wimpi.pim.contact.model.Address;
import net.wimpi.pim.contact.model.Communications;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.EmailAddress;
import net.wimpi.pim.contact.model.GeographicalInformation;
import net.wimpi.pim.contact.model.Image;
import net.wimpi.pim.contact.model.Key;
import net.wimpi.pim.contact.model.Organization;
import net.wimpi.pim.contact.model.OrganizationalIdentity;
import net.wimpi.pim.contact.model.PersonalIdentity;
import net.wimpi.pim.contact.model.PhoneNumber;
import net.wimpi.pim.contact.model.Sound;
import net.wimpi.pim.factory.ContactIOFactory;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.subcrawler.SubCrawler;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerException;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerHandler;
import org.semanticdesktop.aperture.util.DateUtil;
import org.semanticdesktop.aperture.util.StringUtil;
import org.semanticdesktop.aperture.util.UriUtil;
import org.semanticdesktop.aperture.vocabulary.GEO;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NEXIF;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;

public class VcardSubCrawler
implements SubCrawler {
    private static final String OBJECT_HASH_KEY = "contactHash";

    public void subCrawl(URI uRI, InputStream inputStream, SubCrawlerHandler subCrawlerHandler, DataSource dataSource, AccessData accessData, Charset charset, String string, RDFContainer rDFContainer) throws SubCrawlerException {
        if (subCrawlerHandler == null) {
            throw new SubCrawlerException("The SubCrawlerHandler cannot be null");
        }
        if (rDFContainer == null) {
            throw new SubCrawlerException("The parentMetadata cannot be null");
        }
        try {
            ContactIOFactory contactIOFactory = Pim.getContactIOFactory();
            ContactUnmarshaller contactUnmarshaller = contactIOFactory.createContactUnmarshaller();
            ContactMarshaller contactMarshaller = contactIOFactory.createContactMarshaller();
            Contact[] contactArray = contactUnmarshaller.unmarshallContacts(inputStream);
            if (contactArray.length == 0) {
                return;
            }
            if (contactArray.length == 1) {
                this.processContact(contactArray[0], rDFContainer.getModel(), (Resource)rDFContainer.getDescribedUri());
            } else {
                this.processAddressBook(contactArray, rDFContainer, subCrawlerHandler, contactMarshaller, accessData, dataSource);
            }
        }
        catch (Exception exception) {
            throw new SubCrawlerException(exception);
        }
    }

    public void stopSubCrawler() {
    }

    private void processAddressBook(Contact[] contactArray, RDFContainer rDFContainer, SubCrawlerHandler subCrawlerHandler, ContactMarshaller contactMarshaller, AccessData accessData, DataSource dataSource) {
        rDFContainer.add(RDF.type, (Node)NCO.ContactList);
        for (Contact contact : contactArray) {
            String string = this.getContactHash(contact, contactMarshaller);
            URI uRI = this.generateURIForContact(contact, rDFContainer, string);
            RDFContainerFactory rDFContainerFactory = subCrawlerHandler.getRDFContainerFactory(uRI.toString());
            RDFContainer rDFContainer2 = rDFContainerFactory.getRDFContainer(uRI);
            this.processContact(contact, rDFContainer2.getModel(), (Resource)uRI);
            rDFContainer.add(NCO.containsContact, (Node)uRI);
            rDFContainer2.add(RDF.type, (Node)NCO.ContactListDataObject);
            this.passMetadataToHandler(rDFContainer2, subCrawlerHandler, string, accessData, dataSource);
        }
    }

    private void passMetadataToHandler(RDFContainer rDFContainer, SubCrawlerHandler subCrawlerHandler, String string, AccessData accessData, DataSource dataSource) {
        URI uRI = rDFContainer.getDescribedUri();
        DataObjectBase dataObjectBase = new DataObjectBase(uRI, dataSource, rDFContainer);
        if (accessData == null) {
            subCrawlerHandler.objectNew(dataObjectBase);
        } else if (!accessData.isKnownId(uRI.toString())) {
            accessData.put(uRI.toString(), OBJECT_HASH_KEY, string);
            subCrawlerHandler.objectNew(dataObjectBase);
        } else {
            String string2 = accessData.get(uRI.toString(), OBJECT_HASH_KEY);
            if (string2 == null || !string2.equals(string)) {
                accessData.put(uRI.toString(), OBJECT_HASH_KEY, string);
                subCrawlerHandler.objectChanged(dataObjectBase);
            } else {
                subCrawlerHandler.objectNotModified(uRI.toString());
            }
        }
    }

    private void processContact(Contact contact, Model model, Resource resource) {
        model.addStatement(resource, RDF.type, (Node)NCO.Contact);
        this.processPersonalIdentity(contact.getPersonalIdentity(), model, resource);
        Resource resource2 = this.processOrganizationIdentity(contact.getOrganizationalIdentity(), model, resource);
        this.processCommonProperties(contact, model, resource, resource2);
    }

    private void processPersonalIdentity(PersonalIdentity personalIdentity, Model model, Resource resource) {
        int n;
        if (personalIdentity == null) {
            return;
        }
        this.addStringProperty(model, resource, NCO.fullname, personalIdentity.getFormattedName());
        if (personalIdentity.getAdditionalNameCount() > 0 || personalIdentity.getBirthDate() != null || personalIdentity.getFirstname() != null || personalIdentity.getLastname() != null || personalIdentity.getNicknameCount() > 0 || personalIdentity.listPrefixes().length > 0 || personalIdentity.listSuffixes().length > 0) {
            model.addStatement(resource, RDF.type, (Node)NCO.PersonContact);
        }
        for (n = 0; n < personalIdentity.getAdditionalNameCount(); ++n) {
            model.addStatement(resource, NCO.nameAdditional, personalIdentity.getAdditionalName(n));
        }
        this.addDateProperty(model, resource, NCO.birthDate, personalIdentity.getBirthDate());
        this.addStringProperty(model, resource, NCO.nameGiven, personalIdentity.getFirstname());
        for (n = 0; n < personalIdentity.getAdditionalNameCount(); ++n) {
            model.addStatement(resource, NCO.nameAdditional, personalIdentity.getAdditionalName(n));
        }
        this.addStringProperty(model, resource, NCO.nameFamily, personalIdentity.getLastname());
        for (n = 0; n < personalIdentity.getNicknameCount(); ++n) {
            model.addStatement(resource, NCO.nickname, personalIdentity.getNickname(n));
        }
        this.processImage(model, resource, NCO.photo, personalIdentity.getPhoto());
        for (String string : personalIdentity.listPrefixes()) {
            this.addStringProperty(model, resource, NCO.nameHonorificPrefix, string);
        }
        for (String string : personalIdentity.listSuffixes()) {
            this.addStringProperty(model, resource, NCO.nameHonorificSuffix, string);
        }
    }

    private Resource processOrganizationIdentity(OrganizationalIdentity organizationalIdentity, Model model, Resource resource) {
        if (organizationalIdentity == null) {
            return null;
        }
        if (organizationalIdentity.getAgent() == null && organizationalIdentity.getOrganization() == null && organizationalIdentity.getRole() == null && organizationalIdentity.getTitle() == null) {
            return null;
        }
        model.addStatement(resource, RDF.type, (Node)NCO.PersonContact);
        Resource resource2 = UriUtil.generateRandomResource(model);
        model.addStatement(resource, NCO.hasAffiliation, (Node)resource2);
        model.addStatement(resource2, RDF.type, (Node)NCO.Affiliation);
        this.addStringProperty(model, resource2, NCO.role, organizationalIdentity.getRole());
        this.addStringProperty(model, resource2, NCO.title, organizationalIdentity.getTitle());
        if (organizationalIdentity.getAgent() == null && organizationalIdentity.getOrganization() == null) {
            return resource2;
        }
        Resource resource3 = UriUtil.generateRandomResource(model);
        model.addStatement(resource3, RDF.type, (Node)NCO.OrganizationContact);
        model.addStatement(resource2, NCO.org, (Node)resource3);
        Organization organization = organizationalIdentity.getOrganization();
        if (organization != null) {
            this.addStringProperty(model, resource3, NCO.fullname, organization.getName());
            this.processImage(model, resource3, NCO.logo, organization.getLogo());
            for (int i = 0; i < organization.getUnitCount(); ++i) {
                this.addStringProperty(model, resource2, NCO.department, organization.getUnit(i));
            }
        }
        return resource2;
    }

    private void processCommonProperties(Contact contact, Model model, Resource resource, Resource resource2) {
        Address address = contact.getPreferredAddress();
        for (Address address2 : contact.listAddresses()) {
            if (address == address2) {
                this.processAddress(model, address2, resource, resource2, true);
                continue;
            }
            this.processAddress(model, address2, resource, resource2, false);
        }
        this.processCommunications(model, contact.getCommunications(), resource, resource2);
        this.processGeographicalInformation(model, resource, NCO.hasLocation, contact.getGeographicalInformation());
        this.processPublicKey(model, resource, NCO.key, contact.getPublicKey());
        this.processSound(model, resource, NCO.sound, contact.getSound());
        this.addStringProperty(model, resource, NCO.contactUID, contact.getUID());
        this.addUriProperty(model, resource, NCO.url, contact.getURL());
        this.addStringProperty(model, resource, NCO.note, contact.getNote());
        this.addDateTimeProperty(model, resource, NIE.contentLastModified, contact.getCurrentRevisionDate());
    }

    private void processAddress(Model model, Address address, Resource resource, Resource resource2, boolean bl) {
        if (address != null) {
            Resource resource3 = UriUtil.generateRandomResource(model);
            model.addStatement(resource3, RDF.type, (Node)NCO.PostalAddress);
            this.addStringProperty(model, resource3, NCO.locality, address.getCity());
            this.addStringProperty(model, resource3, NCO.country, address.getCountry());
            this.addStringProperty(model, resource3, NCO.postalcode, address.getPostalCode());
            this.addStringProperty(model, resource3, NCO.pobox, address.getPostBox());
            this.addStringProperty(model, resource3, NCO.region, address.getRegion());
            this.addStringProperty(model, resource3, NCO.streetAddress, address.getStreet());
            this.addStringProperty(model, resource3, NCO.extendedAddress, address.getExtended());
            address.isPostal();
            if (address.isDomestic()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.DomesticDeliveryAddress);
                this.addContactMediumProperty(model, resource, NCO.hasPostalAddress, resource3, bl);
            }
            if (address.isInternational()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.InternationalDeliveryAddress);
                this.addContactMediumProperty(model, resource, NCO.hasPostalAddress, resource3, bl);
            }
            if (address.isParcel()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.ParcelDeliveryAddress);
                this.addContactMediumProperty(model, resource, NCO.hasPostalAddress, resource3, bl);
            }
            if (address.isWork()) {
                if (resource2 != null) {
                    this.addContactMediumProperty(model, resource2, NCO.hasPostalAddress, resource3, bl);
                } else {
                    resource2 = UriUtil.generateRandomResource(model);
                    model.addStatement(resource2, RDF.type, (Node)NCO.Affiliation);
                    model.addStatement(resource, NCO.hasAffiliation, (Node)resource2);
                    this.addContactMediumProperty(model, resource, NCO.hasPostalAddress, resource3, bl);
                }
            }
            if (address.isHome()) {
                this.addContactMediumProperty(model, resource, NCO.hasPostalAddress, resource3, bl);
            }
            if (!(address.isDomestic() || address.isHome() || address.isInternational() || address.isParcel() || address.isPostal() || address.isWork())) {
                this.addContactMediumProperty(model, resource, NCO.hasPostalAddress, resource3, bl);
            }
        }
    }

    private void processCommunications(Model model, Communications communications, Resource resource, Resource resource2) {
        if (communications != null) {
            EmailAddress emailAddress = communications.getPreferredEmailAddress();
            for (EmailAddress emailAddress2 : communications.listEmailAddresses()) {
                if (emailAddress == emailAddress2) {
                    this.processEmailAddress(model, emailAddress2, resource, resource2, true);
                    continue;
                }
                this.processEmailAddress(model, emailAddress2, resource, resource2, false);
            }
            for (EmailAddress emailAddress2 : communications.listPhoneNumbers()) {
                this.processPhoneNumber(model, (PhoneNumber)emailAddress2, resource, resource2);
            }
        }
    }

    private void processPhoneNumber(Model model, PhoneNumber phoneNumber, Resource resource, Resource resource2) {
        if (phoneNumber != null) {
            Resource resource3 = UriUtil.generateRandomResource(model);
            model.addStatement(resource3, RDF.type, (Node)NCO.PhoneNumber);
            this.addStringProperty(model, resource3, NCO.phoneNumber, phoneNumber.getNumber());
            if (phoneNumber.isBBS()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.BbsNumber);
            }
            if (phoneNumber.isCar()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.CarPhoneNumber);
            }
            if (phoneNumber.isCellular()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.CellPhoneNumber);
            }
            if (phoneNumber.isFax()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.FaxNumber);
            }
            if (phoneNumber.isHome()) {
                this.addContactMediumProperty(model, resource, NCO.hasPhoneNumber, resource3, phoneNumber.isPreferred());
            }
            if (phoneNumber.isISDN()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.IsdnNumber);
            }
            if (phoneNumber.isMessaging()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.MessagingNumber);
            }
            if (phoneNumber.isMODEM()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.ModemNumber);
            }
            if (phoneNumber.isPager()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.PagerNumber);
            }
            if (phoneNumber.isPCS()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.PcsNumber);
            }
            if (phoneNumber.isVideo()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.VideoTelephoneNumber);
            }
            if (phoneNumber.isVoice()) {
                model.addStatement(resource3, RDF.type, (Node)NCO.VoicePhoneNumber);
            }
            if (phoneNumber.isWork()) {
                if (resource2 != null) {
                    this.addContactMediumProperty(model, resource2, NCO.hasPhoneNumber, resource3, phoneNumber.isPreferred());
                } else {
                    resource2 = UriUtil.generateRandomResource(model);
                    model.addStatement(resource2, RDF.type, (Node)NCO.Affiliation);
                    model.addStatement(resource, NCO.hasAffiliation, (Node)resource2);
                    this.addContactMediumProperty(model, resource, NCO.hasPhoneNumber, resource3, phoneNumber.isPreferred());
                }
            }
            if (!phoneNumber.isHome() && !phoneNumber.isWork()) {
                this.addContactMediumProperty(model, resource, NCO.hasPhoneNumber, resource3, phoneNumber.isPreferred());
            }
        }
    }

    private void processEmailAddress(Model model, EmailAddress emailAddress, Resource resource, Resource resource2, boolean bl) {
        if (emailAddress != null && emailAddress.isType("INTERNET")) {
            Resource resource3 = UriUtil.generateRandomResource(model);
            model.addStatement(resource3, RDF.type, (Node)NCO.EmailAddress);
            this.addStringProperty(model, resource3, NCO.emailAddress, emailAddress.getAddress());
            this.addContactMediumProperty(model, resource, NCO.hasEmailAddress, resource3, bl);
        }
    }

    private void processGeographicalInformation(Model model, Resource resource, URI uRI, GeographicalInformation geographicalInformation) {
        if (geographicalInformation != null) {
            Resource resource2 = UriUtil.generateRandomResource(model);
            model.addStatement(resource2, RDF.type, (Node)GEO.Point);
            model.addStatement(resource2, GEO.lat, geographicalInformation.getLatitude().toPlainString());
            model.addStatement(resource2, GEO.long_, geographicalInformation.getLongitude().toPlainString());
            model.addStatement(resource, uRI, (Node)resource2);
        }
    }

    private void processImage(Model model, Resource resource, URI uRI, Image image) {
        if (image != null) {
            Resource resource2 = UriUtil.generateRandomResource(model);
            model.addStatement(resource2, RDF.type, (Node)NEXIF.Photo);
            model.addStatement(resource2, RDF.type, (Node)NFO.Attachment);
            model.addStatement(resource, uRI, (Node)resource2);
            this.addStringProperty(model, resource2, NIE.mimeType, image.getContentType());
        }
    }

    private void processSound(Model model, Resource resource, URI uRI, Sound sound) {
        if (sound != null) {
            Resource resource2 = UriUtil.generateRandomResource(model);
            model.addStatement(resource2, RDF.type, (Node)NFO.Audio);
            model.addStatement(resource2, RDF.type, (Node)NFO.Attachment);
            model.addStatement(resource, uRI, (Node)resource2);
            this.addStringProperty(model, resource2, NIE.mimeType, sound.getContentType());
        }
    }

    private void processPublicKey(Model model, Resource resource, URI uRI, Key key) {
        if (key != null) {
            Resource resource2 = UriUtil.generateRandomResource(model);
            model.addStatement(resource2, RDF.type, (Node)NIE.InformationElement);
            model.addStatement(resource2, RDF.type, (Node)NFO.Attachment);
            model.addStatement(resource, uRI, (Node)resource2);
            this.addStringProperty(model, resource2, NIE.mimeType, key.getContentType());
        }
    }

    private void addStringProperty(Model model, Resource resource, URI uRI, String string) {
        if (string != null && string.trim().length() > 0) {
            model.addStatement(resource, uRI, string);
        }
    }

    private void addDateProperty(Model model, Resource resource, URI uRI, Date date) {
        if (date != null) {
            String string = DateUtil.date2String(date);
            model.addStatement(resource, uRI, (Node)model.createDatatypeLiteral(string, XSD._date));
        }
    }

    private void addDateTimeProperty(Model model, Resource resource, URI uRI, Date date) {
        if (date != null) {
            String string = DateUtil.dateTime2String(date);
            model.addStatement(resource, uRI, (Node)model.createDatatypeLiteral(string + "Z", XSD._dateTime));
        }
    }

    private void addUriProperty(Model model, Resource resource, URI uRI, String string) {
        if (string != null) {
            URI uRI2 = model.createURI(string);
            model.addStatement(resource, uRI, (Node)uRI2);
            model.addStatement((Resource)uRI2, RDF.type, (Node)RDFS.Resource);
        }
    }

    private void addContactMediumProperty(Model model, Resource resource, URI uRI, Resource resource2, boolean bl) {
        model.addStatement(resource, uRI, (Node)resource2);
        if (bl) {
            // empty if block
        }
    }

    private URI generateURIForContact(Contact contact, RDFContainer rDFContainer, String string) {
        String string2 = null;
        String string3 = contact.getUID();
        string2 = string3 != null ? string3 : string;
        return rDFContainer.getModel().createURI(rDFContainer.getDescribedUri().toString() + "#" + string2);
    }

    private String getContactHash(Contact contact, ContactMarshaller contactMarshaller) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        contactMarshaller.marshallContact((OutputStream)byteArrayOutputStream, contact);
        return StringUtil.sha1Hash(byteArrayOutputStream.toByteArray());
    }
}

