/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.StringTokenizer;
import org.semanticdesktop.aperture.util.IOUtil;

public class FileUtil {
    private static final String ILLEGAL_FILE_NAME_CHARS = "\\/:*?\"<>|";

    public static String getRelativePath(File file, File file2) {
        int n;
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        if (!file.isDirectory() && (n = string.lastIndexOf(File.separator)) != -1) {
            string = string.substring(0, n);
        }
        if (!file2.isDirectory() && (n = string2.lastIndexOf(File.separator)) != -1) {
            string2 = string2.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, File.separator);
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens() && (string3 = stringTokenizer.nextToken()).equals(string4 = stringTokenizer2.nextToken())) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!string3.equals(string4)) {
            stringBuilder.append("..");
            stringBuilder.append(File.separator);
        }
        while (stringTokenizer2.hasMoreTokens()) {
            stringTokenizer2.nextToken();
            stringBuilder.append("..");
            stringBuilder.append(File.separator);
        }
        if (!string3.equals(string4)) {
            stringBuilder.append(string3);
            stringBuilder.append(File.separator);
        }
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            stringBuilder.append(string3);
            stringBuilder.append(File.separator);
        }
        stringBuilder.append(file.getName());
        return stringBuilder.toString();
    }

    public static File getRelativeFile(File file, File file2) {
        return new File(FileUtil.getRelativePath(file, file2));
    }

    public static String getFileExtension(String string) {
        String string2;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1 && FileUtil.isLegalFileName(string2 = string.substring(n + 1).trim())) {
            return string2;
        }
        return null;
    }

    public static boolean isLegalFileName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (FileUtil.isLegalFileNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalFileNameChar(char c) {
        return ILLEGAL_FILE_NAME_CHARS.indexOf(c) == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            IOUtil.writeStream((InputStream)fileInputStream, file2);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static void createDirIfNotExists(File file) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Unable to create directory: " + file.toString());
        }
    }

    public static boolean deltree(File file) {
        if (file == null || !file.exists()) {
            return true;
        }
        boolean bl = true;
        if (file.isFile()) {
            bl = file.delete();
        } else {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            while (n-- > 0) {
                if (FileUtil.deltree(fileArray[n])) continue;
                bl = false;
            }
            if (!file.delete()) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean deleteChildren(File file) {
        boolean bl = true;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            while (n-- > 0) {
                bl = bl && FileUtil.deltree(fileArray[n]);
            }
        }
        return bl;
    }

    public static boolean moveRecursive(File file, File file2, Collection collection) {
        if (file == null || !file.exists()) {
            return false;
        }
        boolean bl = true;
        if (file.isFile()) {
            if (collection == null || !collection.contains(file)) {
                file2.getParentFile().mkdirs();
                bl = file.renameTo(file2);
            }
        } else {
            boolean bl2 = false;
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            while (n-- > 0) {
                File file3 = fileArray[n];
                if (collection != null && collection.contains(file3)) {
                    bl2 = true;
                    continue;
                }
                if (FileUtil.moveRecursive(file3, new File(file2, file3.getName()), collection)) continue;
                bl = false;
            }
            if (!bl2 && !file.delete()) {
                bl = false;
            }
        }
        return bl;
    }

    public static String readWholeFileAsUTF8(String string) throws IOException {
        return FileUtil.readWholeFileAsEncoding(string, "utf-8");
    }

    public static String readStreamAsUTF8(InputStream inputStream) throws IOException {
        return FileUtil.readStreamAsEncoding(inputStream, "utf-8");
    }

    public static String readStreamAsEncoding(InputStream inputStream, String string) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(FileUtil.asEncoding(inputStream, string), 1024);
        StringWriter stringWriter = new StringWriter(1024);
        char[] cArray = new char[1024];
        while (((Reader)bufferedReader).ready() && (n = bufferedReader.read(cArray)) > 0) {
            stringWriter.write(cArray, 0, n);
        }
        ((Reader)bufferedReader).close();
        stringWriter.close();
        return stringWriter.toString();
    }

    public static String readWholeFileAsEncoding(String string, String string2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        return FileUtil.readStreamAsEncoding(fileInputStream, string2);
    }

    private static Reader asEncoding(InputStream inputStream, String string) {
        Charset charset = Charset.forName(string);
        return new InputStreamReader(inputStream, charset.newDecoder());
    }
}

