/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.validator;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.util.RDFTool;
import org.semanticdesktop.nepomuk.nrl.validator.StandaloneValidator;
import org.semanticdesktop.nepomuk.nrl.validator.ValidationMessage;
import org.semanticdesktop.nepomuk.nrl.validator.ValidationReport;
import org.semanticdesktop.nepomuk.nrl.validator.impl.StandaloneValidatorImpl;
import org.semanticdesktop.nepomuk.nrl.validator.testers.NRLClosedWorldModelTester;

public class ConsoleFrontend {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Give at least one ontology and a data file");
            System.exit(-1);
        }
        StandaloneValidatorImpl validator = new StandaloneValidatorImpl();
        validator.setModelTesters(new NRLClosedWorldModelTester());
        ConsoleFrontend.addOntologies(args, validator);
        File dataFile = new File(args[args.length - 1]);
        Syntax syntax = RDFTool.guessSyntax((String)dataFile.getName());
        ValidationReport report = validator.validate(dataFile, syntax.getMimeType());
        ConsoleFrontend.printValidationReport(report);
    }

    private static void addOntologies(String[] args, StandaloneValidator validator) throws Exception {
        int i = 0;
        while (i < args.length - 1) {
            File file = new File(args[i]);
            Syntax syntax = RDFTool.guessSyntax((String)args[i]);
            FileInputStream fileInputStream = new FileInputStream(file);
            String ontologyUri = "uri:ontology:" + i;
            validator.addOntology(fileInputStream, syntax.getMimeType(), ontologyUri);
            ++i;
        }
    }

    private static void printValidationReport(ValidationReport report) {
        System.out.println("Validation report");
        List<ValidationMessage> messages = report.getMessages();
        int i = 1;
        for (ValidationMessage msg : messages) {
            System.out.print(i + ": ");
            System.out.println(String.valueOf(msg.getMessageType().toString()) + " ");
            System.out.println("   " + msg.getMessageTitle() + " ");
            System.out.println("   " + msg.getMessage() + " ");
            for (Statement stmt : msg.getStatements()) {
                System.out.println("   {" + ConsoleFrontend.nodeToString((Node)stmt.getSubject()) + ",");
                System.out.println("    " + ConsoleFrontend.nodeToString((Node)stmt.getPredicate()) + ",");
                System.out.println("    " + ConsoleFrontend.nodeToString(stmt.getObject()) + "}");
            }
            ++i;
        }
    }

    private static String nodeToString(Node node) {
        if (node instanceof BlankNode) {
            return "_:" + node.toString();
        }
        return node.toSPARQL();
    }
}

