/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.validator.testers;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.util.RDFTool;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.nepomuk.nrl.validator.ModelTester;
import org.semanticdesktop.nepomuk.nrl.validator.ValidationMessage;
import org.semanticdesktop.nepomuk.nrl.validator.ValidationReport;
import org.semanticdesktop.nepomuk.nrl.validator.exception.ModelTesterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObjectTreeModelTester
implements ModelTester {
    private static final String NIE_NS = "http://www.semanticdesktop.org/ontologies/2007/01/19/nie#";
    private static final URI NIE_DATA_OBJECT = new URIImpl("http://www.semanticdesktop.org/ontologies/2007/01/19/nie#DataObject");
    private static final URI NIE_INFORMATION_ELEMENT = new URIImpl("http://www.semanticdesktop.org/ontologies/2007/01/19/nie#InformationElement");
    private static final URI NIE_ROOT_ELEMENT_OF = new URIImpl("http://www.semanticdesktop.org/ontologies/2007/01/19/nie#rootElementOf");
    private static final URI NIE_IS_PART_OF = new URIImpl("http://www.semanticdesktop.org/ontologies/2007/01/19/nie#isPartOf");
    private static final URI NIE_HAS_PART = new URIImpl("http://www.semanticdesktop.org/ontologies/2007/01/19/nie#hasPart");
    private static final URI NIE_IS_STORED_IN = new URIImpl("http://www.semanticdesktop.org/ontologies/2007/01/19/nie#isStoredIn");

    @Override
    public ValidationReport performTests(Model unionModel, Model dataModel) throws ModelTesterException {
        ValidationReport report = new ValidationReport();
        this.performTests(unionModel, dataModel, report);
        return report;
    }

    @Override
    public void performTests(Model unionModel, Model dataModel, ValidationReport report) throws ModelTesterException {
        List<Resource> rootElementList = this.getRootElements(unionModel);
        if (rootElementList.size() == 0) {
            this.reportNoRootElements(report);
            return;
        }
        Set<Resource> dataObjectSet = this.getIndividuals(unionModel, NIE_DATA_OBJECT);
        Set<Resource> informationElementSet = this.getIndividuals(unionModel, NIE_INFORMATION_ELEMENT);
        for (Resource rootElement : rootElementList) {
            this.processSingleRootElement(rootElement, unionModel, dataObjectSet, informationElementSet, report);
        }
        this.reportInaccessibleDataObjects(unionModel, report, dataObjectSet);
    }

    private void processSingleRootElement(Resource rootElement, Model unionModel, Set<Resource> dataObjectSet, Set<Resource> informationElementSet, ValidationReport report) {
        if (!this.resourceHasType(unionModel, rootElement, NIE_INFORMATION_ELEMENT)) {
            this.reportRootElementIsNotAnElement(rootElement, unionModel, report);
            return;
        }
        List<Resource> parentsOfRootElement = this.getParentsOfRootElement(rootElement, unionModel);
        boolean rootElementOk = true;
        for (Resource parentOfRootElement : parentsOfRootElement) {
            if (!this.parentOfRootElementIsAPartOfAnotherObject(parentOfRootElement, unionModel, report, informationElementSet, dataObjectSet)) continue;
            rootElementOk = false;
        }
        if (!rootElementOk) {
            return;
        }
        this.crawlInformationElement(rootElement, unionModel, dataObjectSet, informationElementSet, report);
    }

    private List<Resource> getParentsOfRootElement(Resource rootElement, Model model) {
        ClosableIterator iterator = null;
        Resource dataObjectResource = this.getDataObjectForAnInformationElement(rootElement, model);
        LinkedList<Resource> result = new LinkedList<Resource>();
        if (dataObjectResource != null) {
            try {
                iterator = model.findStatements((ResourceOrVariable)dataObjectResource, (UriOrVariable)NIE_IS_PART_OF, (NodeOrVariable)Variable.ANY);
                while (iterator.hasNext()) {
                    Statement statement = (Statement)iterator.next();
                    Node node = statement.getObject();
                    if (!(node instanceof Resource)) continue;
                    result.add(statement.getObject().asResource());
                }
            }
            catch (Throwable throwable) {
                this.closeIterator(iterator);
                throw throwable;
            }
            this.closeIterator((ClosableIterator<? extends Object>)iterator);
        }
        return result;
    }

    private void crawlInformationElement(Resource element, Model model, Set<Resource> dataObjectSet, Set<Resource> informationElementSet, ValidationReport report) {
        if (!informationElementSet.remove(element)) {
            this.reportContainmentTreeNodeOccuringTwice(element, model, NIE_INFORMATION_ELEMENT, report);
            return;
        }
        Resource dataObject = this.getDataObjectForAnInformationElement(element, model);
        if (dataObject != null && !dataObjectSet.remove(dataObject)) {
            this.reportContainmentTreeNodeOccuringTwice(dataObject, model, NIE_DATA_OBJECT, report);
            return;
        }
        List<Resource> childDataObjects = this.getAllPropertyValues(model, element, NIE_HAS_PART);
        LinkedList<Resource> childInformationElements = new LinkedList<Resource>();
        for (Resource childDataObject : childDataObjects) {
            Resource childInformationElement = this.getInformationElementForADataObject(childDataObject, model);
            if (childInformationElement != null) {
                childInformationElements.add(childInformationElement);
                continue;
            }
            dataObjectSet.remove(childDataObject);
        }
        for (Resource childInformationElement : childInformationElements) {
            this.crawlInformationElement(childInformationElement, model, dataObjectSet, informationElementSet, report);
        }
    }

    private boolean resourceHasType(Model model, Resource subject, URI type) {
        ClosableIterator iterator = null;
        try {
            iterator = model.findStatements((ResourceOrVariable)subject, (UriOrVariable)RDF.type, (NodeOrVariable)type);
            if (iterator.hasNext()) {
                this.closeIterator((ClosableIterator<? extends Object>)iterator);
                return true;
            }
            this.closeIterator((ClosableIterator<? extends Object>)iterator);
            return false;
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
    }

    private Set<Resource> getIndividuals(Model model, URI type) {
        HashSet<Resource> result = new HashSet<Resource>();
        ClosableIterator iterator = null;
        try {
            iterator = model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)RDF.type, (NodeOrVariable)type);
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                result.add(statement.getSubject());
            }
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
        this.closeIterator((ClosableIterator<? extends Object>)iterator);
        return result;
    }

    private List<Resource> getRootElements(Model model) {
        LinkedList<Resource> result = new LinkedList<Resource>();
        ClosableIterator iterator = null;
        try {
            iterator = model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)NIE_ROOT_ELEMENT_OF, (NodeOrVariable)Variable.ANY);
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                result.add(statement.getSubject());
            }
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
        this.closeIterator((ClosableIterator<? extends Object>)iterator);
        return result;
    }

    private boolean parentOfRootElementIsAPartOfAnotherObject(Resource parentOfRootElement, Model model, ValidationReport report, Set<Resource> dataObjectSet, Set<Resource> informationElementSet) {
        boolean result = false;
        Resource dataObjectResource = this.getDataObjectForAnInformationElement(parentOfRootElement, model);
        if (dataObjectResource == null) {
            informationElementSet.remove(parentOfRootElement);
            return false;
        }
        informationElementSet.remove(parentOfRootElement);
        dataObjectSet.remove(dataObjectResource);
        ClosableIterator iterator = null;
        try {
            iterator = model.findStatements((ResourceOrVariable)dataObjectResource, (UriOrVariable)NIE_IS_PART_OF, (NodeOrVariable)Variable.ANY);
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                report.addMessage(ValidationMessage.MessageType.ERROR, "Root element error", "An element that contains the root element is itself contained somewhere", statement);
                result = true;
            }
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
        this.closeIterator((ClosableIterator<? extends Object>)iterator);
        return result;
    }

    private Resource getDataObjectForAnInformationElement(Resource element, Model model) {
        if (this.resourceHasType(model, element, NIE_DATA_OBJECT)) {
            return element;
        }
        Node dataObjectNode = RDFTool.getSingleValue((Model)model, (Resource)element, (URI)NIE_IS_STORED_IN);
        if (dataObjectNode != null && dataObjectNode instanceof Resource) {
            return dataObjectNode.asResource();
        }
        return null;
    }

    private Resource getInformationElementForADataObject(Resource dataObject, Model model) {
        if (this.resourceHasType(model, dataObject, NIE_INFORMATION_ELEMENT)) {
            return dataObject;
        }
        return this.getAnySubjectOfProperty(model, NIE_IS_STORED_IN, dataObject);
    }

    private Resource getAnySubjectOfProperty(Model model, URI predicate, Resource object) {
        ClosableIterator iterator = null;
        try {
            iterator = model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)predicate, (NodeOrVariable)object);
            Resource result = null;
            if (iterator.hasNext()) {
                result = ((Statement)iterator.next()).getSubject();
            }
            Resource resource = result;
            this.closeIterator((ClosableIterator<? extends Object>)iterator);
            return resource;
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
    }

    private List<Resource> getAllPropertyValues(Model model, Resource subject, URI predicate) {
        LinkedList<Resource> result = new LinkedList<Resource>();
        ClosableIterator iterator = null;
        try {
            iterator = model.findStatements((ResourceOrVariable)subject, (UriOrVariable)predicate, (NodeOrVariable)Variable.ANY);
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                result.add(statement.getObject().asResource());
            }
        }
        catch (Throwable throwable) {
            this.closeIterator(iterator);
            throw throwable;
        }
        this.closeIterator((ClosableIterator<? extends Object>)iterator);
        return result;
    }

    private void closeIterator(ClosableIterator<? extends Object> iterator) {
        if (iterator != null) {
            try {
                iterator.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void reportRootElementIsNotAnElement(Resource rootElement, Model unionModel, ValidationReport report) {
        report.addMessage(ValidationMessage.MessageType.ERROR, "Root element error", "The root element is not an InformationElement", unionModel.createStatement(rootElement, NIE_ROOT_ELEMENT_OF, RDFTool.getSingleValue((Model)unionModel, (Resource)rootElement, (URI)NIE_ROOT_ELEMENT_OF)));
    }

    private void reportInaccessibleDataObjects(Model unionModel, ValidationReport report, Set<Resource> dataObjectSet) {
        for (Resource dataObject : dataObjectSet) {
            report.addMessage(ValidationMessage.MessageType.ERROR, "Inaccessible data object", "Detected a DataObject instance that is not part of a containment tree", unionModel.createStatement(dataObject, RDF.type, (Node)NIE_DATA_OBJECT));
        }
    }

    private void reportNoRootElements(ValidationReport report) {
        report.addMessage(ValidationMessage.MessageType.ERROR, "No root elements", "The model doesn't contain any root elements", null);
    }

    private void reportContainmentTreeNodeOccuringTwice(Resource element, Model model, URI type, ValidationReport report) {
        report.addMessage(ValidationMessage.MessageType.ERROR, "Containment tree error", "A node in the containment tree occurs more than once", model.createStatement(element, RDF.type, (Node)type));
    }
}

