/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import info.aduna.iteration.CloseableIteration;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailConnectionWrapper;
import org.semanticdesktop.nepomuk.openrdf.UnionMaterialisingSail;
import org.semanticdesktop.nepomuk.openrdf.UnionSailConnection;

public class UnionMaterialisingSailConnection
extends SailConnectionWrapper
implements UnionSailConnection {
    private UnionMaterialisingSail sail;

    public UnionMaterialisingSailConnection(UnionMaterialisingSail sail, SailConnection wrappedCon) {
        super(wrappedCon);
        this.sail = sail;
    }

    public long realSize(Resource context) throws SailException {
        return super.size(context);
    }

    public void addStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        super.addStatement(subj, pred, obj, contexts);
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource c = resourceArray[n2];
            if (this.sail.isUnion(c)) {
                throw new SailException("Cannot add to union model: " + c);
            }
            Set<Resource> unions = this.sail.getUnionContexts(c);
            if (unions != null) {
                for (Resource u : unions) {
                    super.addStatement(subj, pred, obj, new Resource[]{u});
                }
            }
            ++n2;
        }
    }

    public void clear(Resource ... contexts) throws SailException {
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource c = resourceArray[n2];
            if (this.sail.isUnion(c)) {
                throw new SailException("Cannot delete from union model: " + c);
            }
            Set<Resource> unions = this.sail.getUnionContexts(c);
            if (unions != null) {
                for (Resource u : unions) {
                    CloseableIteration st = this.getStatements(null, null, null, false, new Resource[]{u});
                    while (st.hasNext()) {
                        Statement s = (Statement)st.next();
                        super.removeStatements(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{u});
                    }
                    st.close();
                }
            }
            ++n2;
        }
        super.clear(contexts);
    }

    public void removeStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        super.removeStatements(subj, pred, obj, contexts);
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource c = resourceArray[n2];
            if (this.sail.isUnion(c)) {
                throw new SailException("Cannot delete from union model: " + c);
            }
            Set<Resource> unions = this.sail.getUnionContexts(c);
            if (unions != null) {
                for (Resource u : unions) {
                    super.removeStatements(subj, pred, obj, new Resource[]{u});
                }
            }
            ++n2;
        }
    }
}

