/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import info.aduna.concurrent.locks.Lock;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.LockingIteration;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.BooleanExprOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.memory.MemoryStore;
import org.openrdf.sail.memory.MemoryStoreConnection;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemValueFactory;
import org.openrdf.sail.memory.model.ReadMode;
import org.semanticdesktop.nepomuk.openrdf.UnionMemoryStore;
import org.semanticdesktop.nepomuk.openrdf.UnionSailConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionMemoryStoreConnection
extends MemoryStoreConnection
implements SailConnection,
UnionSailConnection {
    private UnionMemoryStore unionstore;

    public UnionMemoryStoreConnection(MemoryStore store) throws SailException {
        super(store);
        try {
            this.unionstore = (UnionMemoryStore)store;
        }
        catch (ClassCastException e) {
            throw new SailException("UnionMemoryStoreConnection needs a UnionMemoryStore!", (Throwable)e);
        }
    }

    @Override
    public long realSize(Resource context) throws SailException {
        return super.size(new Resource[]{context});
    }

    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, BindingSet bindings, boolean includeInferred) throws SailException {
        Lock queryLock = this.unionstore.getQueryReadLock();
        try {
            UnionMemTripleSource tripleSource = new UnionMemTripleSource(includeInferred);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl((TripleSource)tripleSource);
            MyMemCostComparator comparator = new MyMemCostComparator();
            QueryJoinOptimizer joinOptimizer = new QueryJoinOptimizer((Comparator)((Object)comparator));
            joinOptimizer.optimize(tupleExpr, EmptyBindingSet.getInstance());
            BooleanExprOptimizer booleanExprOptimizer = new BooleanExprOptimizer((EvaluationStrategy)strategy);
            booleanExprOptimizer.optimize(tupleExpr, EmptyBindingSet.getInstance());
            CloseableIteration iter = null;
            try {
                iter = strategy.evaluate(tupleExpr, bindings);
            }
            catch (QueryEvaluationException e) {
                throw new SailException((Throwable)e);
            }
            return new LockingIteration(queryLock, (Iteration)iter);
        }
        catch (RuntimeException e) {
            queryLock.release();
            throw e;
        }
    }

    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        contexts = this.expandContext(contexts);
        return super.getStatementsInternal(subj, pred, obj, includeInferred, contexts);
    }

    private Resource[] expandContext(Resource ... contexts) {
        HashSet<Resource> res = new HashSet<Resource>();
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (this.unionstore.unions.containsKey(r)) {
                res.addAll(this.expandContext((Collection<? extends Resource>)this.unionstore.unions.get(r)));
            }
            res.add(r);
            ++n2;
        }
        return res.toArray(new Resource[res.size()]);
    }

    private Set<Resource> expandContext(Collection<? extends Resource> contexts) {
        HashSet<Resource> res = new HashSet<Resource>();
        for (Resource resource : contexts) {
            if (this.unionstore.unions.containsKey(resource)) {
                res.addAll(this.expandContext((Collection<? extends Resource>)this.unionstore.unions.get(resource)));
                continue;
            }
            res.add(resource);
        }
        return res;
    }

    public class MyMemCostComparator
    extends MemoryStoreConnection.MemCostComparator {
        public MyMemCostComparator() {
            super((MemoryStoreConnection)UnionMemoryStoreConnection.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UnionMemTripleSource
    implements TripleSource {
        private boolean _includeInferred;

        public UnionMemTripleSource(boolean includeInferred) {
            this._includeInferred = includeInferred;
        }

        public CloseableIteration<MemStatement, QueryEvaluationException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) {
            contexts = UnionMemoryStoreConnection.this.expandContext(contexts);
            return UnionMemoryStoreConnection.this.unionstore.createStatementIterator(QueryEvaluationException.class, subj, pred, obj, !this._includeInferred, ReadMode.COMMITTED, contexts);
        }

        public MemValueFactory getValueFactory() {
            return UnionMemoryStoreConnection.this.unionstore.getValueFactory();
        }
    }
}

