/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.ontoware.aifbcommons.collection.ClosableIterable;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.MalformedQueryException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.exception.QueryLanguageNotSupportedException;
import org.ontoware.rdf2go.exception.SyntaxNotSupportedException;
import org.ontoware.rdf2go.model.Diff;
import org.ontoware.rdf2go.model.DiffReader;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.QueryResultTable;
import org.ontoware.rdf2go.model.QueryRow;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.TriplePattern;
import org.ontoware.rdf2go.model.impl.AbstractModelRemovePatterns;
import org.ontoware.rdf2go.model.impl.DiffImpl;
import org.ontoware.rdf2go.model.impl.StatementImpl;
import org.ontoware.rdf2go.model.impl.TriplePatternImpl;
import org.ontoware.rdf2go.model.impl.URIGenerator;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.LanguageTagLiteral;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.PlainLiteral;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.DatatypeLiteralImpl;
import org.ontoware.rdf2go.model.node.impl.LanguageTagLiteralImpl;
import org.ontoware.rdf2go.model.node.impl.PlainLiteralImpl;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModel
extends AbstractModelRemovePatterns
implements Model {
    private static Logger log = LoggerFactory.getLogger(AbstractModel.class);
    protected Object model;
    private Map<URI, Object> runtimeProperties = new HashMap<URI, Object>();
    private boolean open = false;

    public void addModel(Model model) {
        ClosableIterator it = model.iterator();
        HashSet<Statement> statements = new HashSet<Statement>();
        while (it.hasNext()) {
            Statement stmt = (Statement)it.next();
            statements.add(stmt);
        }
        it.close();
        for (Statement stmt : statements) {
            this.addStatement(stmt.getSubject(), stmt.getPredicate(), stmt.getObject());
        }
    }

    @Override
    public void addAll(Iterator<? extends Statement> other) throws ModelRuntimeException {
        this.assertModel();
        super.addAll(other);
    }

    @Override
    public void addStatement(Resource subject, URI predicate, String literal) throws ModelRuntimeException {
        this.assertModel();
        super.addStatement(subject, predicate, literal);
    }

    @Override
    public void addStatement(Resource subject, URI predicate, String literal, String languageTag) throws ModelRuntimeException {
        this.assertModel();
        super.addStatement(subject, predicate, literal, languageTag);
    }

    @Override
    public void addStatement(Resource subject, URI predicate, String literal, URI datatypeURI) throws ModelRuntimeException {
        this.assertModel();
        super.addStatement(subject, predicate, literal, datatypeURI);
    }

    @Override
    public void addStatement(Statement statement) throws ModelRuntimeException {
        this.assertModel();
        super.addStatement(statement);
    }

    @Override
    public void addStatement(String subjectURIString, URI predicate, String literal) throws ModelRuntimeException {
        this.assertModel();
        super.addStatement(subjectURIString, predicate, literal);
    }

    @Override
    public void addStatement(String subjectURIString, URI predicate, String literal, String languageTag) throws ModelRuntimeException {
        this.assertModel();
        super.addStatement(subjectURIString, predicate, literal, languageTag);
    }

    @Override
    public void addStatement(String subjectURIString, URI predicate, String literal, URI datatypeURI) throws ModelRuntimeException {
        this.assertModel();
        super.addStatement(subjectURIString, predicate, literal, datatypeURI);
    }

    protected void assertModel() {
        if (this.getUnderlyingModelImplementation() == null) {
            throw new ModelRuntimeException("Underlying model is null.");
        }
        if (!this.isOpen()) {
            throw new ModelRuntimeException("Model is not open");
        }
    }

    public void close() {
        if (this.isOpen()) {
            this.open = false;
        } else {
            log.debug("Model was closed already, ignored.");
        }
    }

    public void commit() {
    }

    public boolean contains(ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        this.assertModel();
        ClosableIterator cit = this.findStatements(subject, predicate, object);
        boolean result = cit.hasNext();
        cit.close();
        return result;
    }

    public boolean contains(ResourceOrVariable subject, UriOrVariable predicate, String plainLiteral) throws ModelRuntimeException {
        this.assertModel();
        return this.contains(subject, predicate, (NodeOrVariable)new PlainLiteralImpl(plainLiteral));
    }

    public boolean contains(Statement s) throws ModelRuntimeException {
        this.assertModel();
        return this.contains((ResourceOrVariable)s.getSubject(), (UriOrVariable)s.getPredicate(), (NodeOrVariable)s.getObject());
    }

    public long countStatements(TriplePattern pattern) throws ModelRuntimeException {
        this.assertModel();
        ClosableIterator<Statement> it = this.findStatements(pattern);
        int count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        it.close();
        return count;
    }

    public DatatypeLiteral createDatatypeLiteral(String literal, URI datatypeURI) throws ModelRuntimeException {
        return new DatatypeLiteralImpl(literal, datatypeURI);
    }

    public LanguageTagLiteral createLanguageTagLiteral(String literal, String languageTag) throws ModelRuntimeException {
        return new LanguageTagLiteralImpl(literal, languageTag);
    }

    public PlainLiteral createPlainLiteral(String literal) throws ModelRuntimeException {
        return new PlainLiteralImpl(literal);
    }

    public Statement createStatement(Resource subject, URI predicate, Node object) {
        return new StatementImpl(this.getContextURI(), subject, predicate, object);
    }

    public TriplePattern createTriplePattern(ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) {
        return new TriplePatternImpl(subject, predicate, object);
    }

    public URI createURI(String uriString) throws ModelRuntimeException {
        return new URIImpl(uriString);
    }

    public ClosableIterator<Statement> findStatements(TriplePattern triplepattern) throws ModelRuntimeException {
        this.assertModel();
        return this.findStatements(triplepattern.getSubject(), triplepattern.getPredicate(), triplepattern.getObject());
    }

    public Diff getDiff(Iterator<? extends Statement> other) throws ModelRuntimeException {
        this.assertModel();
        HashSet<Statement> otherSet = new HashSet<Statement>();
        while (other.hasNext()) {
            otherSet.add(other.next());
        }
        log.debug("this has " + this.size() + " triples, other has " + otherSet.size() + " triples");
        HashSet<Statement> added = new HashSet<Statement>();
        for (Statement s : otherSet) {
            if (this.contains(s)) continue;
            added.add(s);
        }
        HashSet<Statement> removed = new HashSet<Statement>();
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            Statement s = (Statement)i$.next();
            if (otherSet.contains(s)) continue;
            log.debug("otherSet does not contain " + s);
            removed.add(s);
        }
        log.debug(added.size() + " triples added, " + removed.size() + " removed.");
        return new DiffImpl(added.iterator(), removed.iterator());
    }

    public Object getProperty(URI propertyURI) {
        return this.runtimeProperties.get(propertyURI);
    }

    public Object getUnderlyingModelImplementation() {
        if (!this.isOpen()) {
            throw new ModelRuntimeException("Model is not open");
        }
        return this.model;
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public boolean isOpen() {
        return this.open;
    }

    public URI newRandomUniqueURI() {
        return URIGenerator.createNewRandomUniqueURI();
    }

    public void open() {
        if (this.isOpen()) {
            log.warn("Model is already open. Ignored.");
        } else {
            this.open = true;
        }
    }

    public ClosableIterable<Statement> queryConstruct(String query, String querylanguage) throws QueryLanguageNotSupportedException, ModelRuntimeException {
        this.assertModel();
        if (querylanguage.equalsIgnoreCase("SPARQL")) {
            return this.sparqlConstruct(query);
        }
        throw new QueryLanguageNotSupportedException("Unsupported query language: " + querylanguage);
    }

    public QueryResultTable querySelect(String query, String querylanguage) throws QueryLanguageNotSupportedException, ModelRuntimeException {
        this.assertModel();
        if (querylanguage.equalsIgnoreCase("SPARQL")) {
            return this.sparqlSelect(query);
        }
        throw new QueryLanguageNotSupportedException("Unsupported query language: " + querylanguage);
    }

    public void readFrom(InputStream in, Syntax syntax) throws IOException, ModelRuntimeException {
        this.assertModel();
        if (syntax != Syntax.RdfXml) {
            throw new ModelRuntimeException("Unsupported syntax: " + syntax);
        }
        this.readFrom(in);
    }

    public void readFrom(InputStream in, Syntax syntax, String baseURI) throws IOException, ModelRuntimeException {
        this.assertModel();
        if (syntax != Syntax.RdfXml) {
            throw new ModelRuntimeException("Unsupported syntax: " + syntax);
        }
        this.readFrom(in);
    }

    public void readFrom(Reader reader, Syntax syntax, String baseURI) throws ModelRuntimeException, IOException {
        this.assertModel();
        if (syntax != Syntax.RdfXml) {
            throw new ModelRuntimeException("Unsupported syntax: " + syntax);
        }
        this.readFrom(reader);
    }

    @Override
    public void removeAll() throws ModelRuntimeException {
        this.assertModel();
        super.removeAll();
    }

    @Override
    public void removeAll(Iterator<? extends Statement> statements) {
        this.assertModel();
        super.removeAll(statements);
    }

    @Override
    public void removeStatement(Resource subject, URI predicate, String literal) throws ModelRuntimeException {
        this.assertModel();
        super.removeStatement(subject, predicate, literal);
    }

    @Override
    public void removeStatement(Resource subject, URI predicate, String literal, String languageTag) throws ModelRuntimeException {
        this.assertModel();
        super.removeStatement(subject, predicate, literal, languageTag);
    }

    @Override
    public void removeStatement(Resource subject, URI predicate, String literal, URI datatypeURI) throws ModelRuntimeException {
        this.assertModel();
        super.removeStatement(subject, predicate, literal, datatypeURI);
    }

    @Override
    public void removeStatement(Statement statement) throws ModelRuntimeException {
        this.assertModel();
        super.removeStatement(statement);
    }

    @Override
    public void removeStatement(String subjectURIString, URI predicate, String literal) throws ModelRuntimeException {
        this.assertModel();
        super.removeStatement(subjectURIString, predicate, literal);
    }

    @Override
    public void removeStatement(String subjectURIString, URI predicate, String literal, String languageTag) throws ModelRuntimeException {
        this.assertModel();
        super.removeStatement(subjectURIString, predicate, literal, languageTag);
    }

    @Override
    public void removeStatement(String subjectURIString, URI predicate, String literal, URI datatypeURI) throws ModelRuntimeException {
        this.assertModel();
        super.removeStatement(subjectURIString, predicate, literal, datatypeURI);
    }

    @Override
    public void removeStatements(ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        this.assertModel();
        super.removeStatements(subject, predicate, object);
    }

    @Override
    public void removeStatements(TriplePattern triplePattern) throws ModelRuntimeException {
        this.assertModel();
        super.removeStatements(triplePattern);
    }

    public String serialize(Syntax syntax) throws SyntaxNotSupportedException {
        StringWriter sw = new StringWriter();
        try {
            this.writeTo(sw, syntax);
        }
        catch (IOException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        return sw.getBuffer().toString();
    }

    public void setAutocommit(boolean autocommit) {
    }

    public void setProperty(URI propertyURI, Object value) {
        this.runtimeProperties.put(propertyURI, value);
    }

    public long size() throws ModelRuntimeException {
        this.assertModel();
        ClosableIterator it = this.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        it.close();
        return count;
    }

    public boolean sparqlAsk(String query) throws ModelRuntimeException, MalformedQueryException {
        QueryResultTable table = this.sparqlSelect(query);
        ClosableIterator it = table.iterator();
        boolean result = it.hasNext();
        it.close();
        return result;
    }

    @Override
    public synchronized void update(DiffReader diff) throws ModelRuntimeException {
        this.assertModel();
        for (Statement r : diff.getRemoved()) {
            this.removeStatement(r);
        }
        for (Statement a : diff.getAdded()) {
            this.addStatement(a);
        }
    }

    public void writeTo(OutputStream out, Syntax syntax) throws IOException, ModelRuntimeException {
        this.assertModel();
        if (syntax != Syntax.RdfXml) {
            throw new ModelRuntimeException("Unsupported syntax: " + syntax);
        }
        this.writeTo(out);
    }

    public BlankNode addReificationOf(Statement statement) {
        BlankNode bnode = this.createBlankNode();
        return (BlankNode)this.addReificationOf(statement, (Resource)bnode);
    }

    public Resource addReificationOf(Statement statement, Resource resource) {
        DiffImpl diff = new DiffImpl();
        diff.addStatement(resource, RDF.type, (Node)RDF.Statement);
        diff.addStatement(resource, RDF.subject, (Node)statement.getSubject());
        diff.addStatement(resource, RDF.predicate, (Node)statement.getPredicate());
        diff.addStatement(resource, RDF.object, statement.getObject());
        this.update((DiffReader)diff);
        return resource;
    }

    public boolean hasReifications(Statement statement) {
        return this.sparqlAsk("ASK WHERE {  ?res " + RDF.type.toSPARQL() + " " + RDF.Statement + " ." + " ?res " + RDF.subject.toSPARQL() + " " + statement.getSubject().toSPARQL() + " ." + " ?res " + RDF.predicate.toSPARQL() + " " + statement.getPredicate().toSPARQL() + " ." + " ?res " + RDF.object.toSPARQL() + " " + statement.getObject().toSPARQL() + " ." + " }");
    }

    public Collection<Resource> getAllReificationsOf(Statement statement) {
        QueryResultTable table = this.sparqlSelect("SELECT ?res WHERE {  ?res " + RDF.type.toSPARQL() + " " + RDF.Statement + " ." + " ?res " + RDF.subject.toSPARQL() + " " + statement.getSubject().toSPARQL() + " ." + " ?res " + RDF.predicate.toSPARQL() + " " + statement.getPredicate().toSPARQL() + " ." + " ?res " + RDF.object.toSPARQL() + " " + statement.getObject().toSPARQL() + " ." + " }");
        LinkedList<Resource> result = new LinkedList<Resource>();
        ClosableIterator it = table.iterator();
        while (it.hasNext()) {
            Resource res = ((QueryRow)it.next()).getValue("res").asResource();
            result.add(res);
        }
        it.close();
        return result;
    }

    public void deleteReification(Resource reificationResource) {
        DiffImpl diff = new DiffImpl();
        diff.removeStatement(reificationResource, RDF.type, (Node)RDF.Statement);
        ClosableIterator it = this.findStatements((ResourceOrVariable)reificationResource, (UriOrVariable)RDF.subject, (NodeOrVariable)Variable.ANY);
        while (it.hasNext()) {
            diff.removeStatement((Statement)it.next());
        }
        it.close();
        it = this.findStatements((ResourceOrVariable)reificationResource, (UriOrVariable)RDF.predicate, (NodeOrVariable)Variable.ANY);
        while (it.hasNext()) {
            diff.removeStatement((Statement)it.next());
        }
        it.close();
        it = this.findStatements((ResourceOrVariable)reificationResource, (UriOrVariable)RDF.object, (NodeOrVariable)Variable.ANY);
        while (it.hasNext()) {
            diff.removeStatement((Statement)it.next());
        }
        it.close();
        this.update((DiffReader)diff);
    }
}

