/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.LockException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Diff;
import org.ontoware.rdf2go.model.DiffReader;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.impl.AbstractModelAddRemove;
import org.ontoware.rdf2go.model.impl.ModelAddRemoveMemoryImpl;
import org.ontoware.rdf2go.model.impl.StatementImpl;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffImpl
extends AbstractModelAddRemove
implements Diff {
    private static final Logger log = LoggerFactory.getLogger(DiffImpl.class);
    private Set<Statement> addedSet = new HashSet<Statement>();
    private Set<Statement> removedSet = new HashSet<Statement>();

    public DiffImpl() {
    }

    public DiffImpl(Iterator<? extends Statement> added, Iterator<? extends Statement> removed) {
        this();
        while (added.hasNext()) {
            this.addedSet.add(added.next());
        }
        while (removed.hasNext()) {
            Statement stmt = removed.next();
            if (this.addedSet.contains(stmt)) {
                this.addedSet.remove(stmt);
                continue;
            }
            this.removedSet.add(stmt);
        }
    }

    public Diff create(Iterator<? extends Statement> added, Iterator<? extends Statement> removed) {
        return new DiffImpl(added, removed);
    }

    public Iterable<Statement> getAdded() {
        return this.addedSet;
    }

    public Iterable<Statement> getRemoved() {
        return this.removedSet;
    }

    @Override
    public void removeStatement(Statement statement) throws ModelRuntimeException {
        this.removedSet.add(statement);
    }

    @Override
    public void removeAll(Iterator<? extends Statement> other) throws ModelRuntimeException {
        while (other.hasNext()) {
            this.removeStatement(other.next());
        }
    }

    @Override
    public void removeAll() throws ModelRuntimeException {
        throw new UnsupportedOperationException("It doesn't make sense to 'remove all' on a Diff");
    }

    public ClosableIterator<Statement> iterator() {
        throw new UnsupportedOperationException("Please iterate over getAdded or getRemoved instead");
    }

    @Override
    public void addStatement(Statement statement) throws ModelRuntimeException {
        this.addedSet.add(statement);
    }

    @Override
    public void addAll(Iterator<? extends Statement> other) throws ModelRuntimeException {
        while (other.hasNext()) {
            this.addStatement(other.next());
        }
    }

    public Diff getDiff(Iterator<? extends Statement> statements) throws ModelRuntimeException {
        throw new UnsupportedOperationException("Doens't make sense for a diff");
    }

    @Override
    public void update(DiffReader diff) throws ModelRuntimeException {
        this.addAll(diff.getAdded().iterator());
        this.removeAll(diff.getRemoved().iterator());
    }

    public void lock() throws LockException {
        throw new UnsupportedOperationException("Doens't make sense for a diff");
    }

    public boolean isLocked() {
        throw new UnsupportedOperationException("Doens't make sense for a diff");
    }

    public void unlock() {
        throw new UnsupportedOperationException("Doens't make sense for a diff");
    }

    @Override
    public void addStatement(Resource subject, URI predicate, Node object) throws ModelRuntimeException {
        this.addStatement(new StatementImpl(null, subject, predicate, object));
    }

    @Override
    public void removeStatement(Resource subject, URI predicate, Node object) throws ModelRuntimeException {
        this.removeStatement(new StatementImpl(null, subject, predicate, object));
    }

    public void dump() {
        log.debug("Dumping diff to System.out");
        ArrayList<Statement> added = new ArrayList<Statement>();
        for (Statement s : this.getAdded()) {
            added.add(s);
        }
        Collections.sort(added);
        for (Statement s : added) {
            System.out.println("[+] " + s);
        }
        ArrayList<Statement> removed = new ArrayList<Statement>();
        for (Statement s : this.getRemoved()) {
            removed.add(s);
        }
        Collections.sort(removed);
        for (Statement s : removed) {
            System.out.println("[-] " + s);
        }
    }

    public static final boolean equals(Set<Statement> a, Set<Statement> b) {
        if (a.size() == b.size()) {
            for (Statement s : a) {
                if (b.contains(s)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof Diff) {
            Diff diff = (Diff)other;
            try {
                log.debug("Comparing two diffs");
                ModelAddRemoveMemoryImpl otherAdded = new ModelAddRemoveMemoryImpl();
                otherAdded.addAll(diff.getAdded().iterator());
                ModelAddRemoveMemoryImpl otherRemoved = new ModelAddRemoveMemoryImpl();
                otherRemoved.addAll(diff.getRemoved().iterator());
                log.debug("This diff: " + this.addedSet.size() + " added and " + this.removedSet.size() + " removed");
                log.debug("Other diff: " + otherAdded.set.size() + " added and " + otherRemoved.set.size() + " removed");
                return DiffImpl.equals(this.addedSet, otherAdded.getSet()) && DiffImpl.equals(this.removedSet, otherRemoved.getSet());
            }
            catch (ModelRuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        if (other == null) {
            log.debug("other is null, but not a DiffImpl");
        } else {
            log.debug("other is not a diff but " + other.getClass());
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.addedSet).hashCode() + ((Object)this.removedSet).hashCode();
    }
}

