/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.impl;

import java.io.IOException;
import java.io.Writer;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.ModelWriter;
import org.ontoware.rdf2go.model.impl.AbstractModelWriter;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.LanguageTagLiteral;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.PlainLiteral;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;

public class StatementWriter
extends AbstractModelWriter
implements ModelWriter {
    private Writer writer;

    public StatementWriter(Writer w, URI graphName) throws IOException {
        this.writer = w;
        w.write("<TriX xmlns=\"http://www.w3.org/2004/03/trix/trix-1/\">\n  <graph>\n    <uri>" + graphName + "</uri>\n");
    }

    public void close() throws IOException {
        this.writer.write("  </graph>\n</TriX>");
    }

    public void addStatement(Resource subject, URI predicate, Node object) throws ModelRuntimeException {
        try {
            this.writer.write("    <triple>\n");
            this.writeNode(subject);
            this.writeNode(predicate);
            this.writeNode(object);
            this.writer.write("    </triple>\n");
        }
        catch (IOException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    private void writeNode(Object node) throws IOException {
        if (node instanceof URI) {
            this.writer.write("      <uri>" + ((URI)node).toString() + "</uri>\n");
        } else if (node instanceof BlankNode) {
            this.writer.write("      <id>" + ((BlankNode)node).toString() + "</id>\n");
        } else if (node instanceof DatatypeLiteral) {
            this.writer.write("      <typedLiteral datatype=\"" + ((DatatypeLiteral)node).getDatatype() + "\">" + ((DatatypeLiteral)node).getValue() + "</typedLiteral>\n");
        } else if (node instanceof LanguageTagLiteral) {
            this.writer.write("      <plainLiteral xml:lang=\"" + ((LanguageTagLiteral)node).getLanguageTag() + "\">" + ((LanguageTagLiteral)node).toString() + "</plainLiteral>\n");
        } else if (node instanceof PlainLiteral) {
            this.writer.write("      <plainLiteral>" + ((PlainLiteral)node).getValue() + "</plainLiteral>\n");
        } else {
            throw new RuntimeException("Cannot write to RDF: " + node.getClass());
        }
    }
}

