/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rdf2go;

import info.aduna.iteration.CloseableIteration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ontoware.aifbcommons.collection.ClosableIterable;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.LockException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Diff;
import org.ontoware.rdf2go.model.DiffReader;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.QueryResultTable;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.impl.AbstractLockingModel;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.rdf2go.ConversionUtil;
import org.openrdf.rdf2go.GraphIterable;
import org.openrdf.rdf2go.OpenrdfBlankNode;
import org.openrdf.rdf2go.RepositoryQueryResultTable;
import org.openrdf.rdf2go.StatementIterator;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryModel
extends AbstractLockingModel
implements Model {
    private static Logger log = LoggerFactory.getLogger(RepositoryModel.class);
    public static final String DEFAULT_CONTEXT = "urn:nullcontext";
    public static final org.openrdf.model.URI DEFAULT_OPENRDF_CONTEXT = null;
    final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Repository repository;
    protected RepositoryConnection connection;
    protected ValueFactory valueFactory;
    private boolean locked = false;
    protected URI context;
    private org.openrdf.model.URI openRdfContext;
    private boolean autocommitBeforeLock;
    private Throwable caller;

    public RepositoryModel(Repository repository) throws ModelRuntimeException {
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        this.repository = repository;
        this.init();
    }

    public RepositoryModel(URI context, Repository repository) throws ModelRuntimeException {
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        this.repository = repository;
        this.context = context;
        this.init();
    }

    private void init() {
        this.valueFactory = this.repository.getValueFactory();
        if (this.context == null) {
            this.context = new URIImpl(DEFAULT_CONTEXT, false);
            this.openRdfContext = DEFAULT_OPENRDF_CONTEXT;
        } else {
            this.openRdfContext = this.valueFactory.createURI(this.context.toString());
        }
    }

    public org.openrdf.model.URI getOpenRDFContextURI() {
        return this.openRdfContext;
    }

    public void open() {
        try {
            this.connection = this.repository.getConnection();
            this.connection.setAutoCommit(true);
            if (log.isDebugEnabled()) {
                try {
                    throw new RuntimeException("Opening model");
                }
                catch (RuntimeException e) {
                    this.caller = e;
                    this.caller.fillInStackTrace();
                }
            }
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public boolean isOpen() throws ModelRuntimeException {
        try {
            return this.connection != null && this.connection.isOpen();
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.isOpen()) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public BlankNode createBlankNode() {
        return new OpenrdfBlankNode(this.valueFactory.createBNode());
    }

    public BlankNode createBlankNode(String internalID) {
        return new OpenrdfBlankNode(this.valueFactory.createBNode(internalID));
    }

    public boolean isValidURI(String uriString) {
        boolean isValid = true;
        try {
            this.valueFactory.createURI(uriString);
        }
        catch (IllegalArgumentException e) {
            isValid = false;
        }
        return isValid;
    }

    public void addStatement(org.ontoware.rdf2go.model.node.Resource subject, URI predicate, Node object) throws ModelRuntimeException {
        this.assertModel();
        try {
            Resource openRdfSubject = (Resource)ConversionUtil.toOpenRDF(subject, this.valueFactory);
            org.openrdf.model.URI openRdfPredicate = ConversionUtil.toOpenRDF(predicate, this.valueFactory);
            Value openRdfObject = ConversionUtil.toOpenRDF(object, this.valueFactory);
            this.connection.add(openRdfSubject, openRdfPredicate, openRdfObject, new Resource[]{this.openRdfContext});
            if (log.isDebugEnabled()) {
                this.connection.commit();
                if (!this.contains((ResourceOrVariable)subject, (UriOrVariable)predicate, (NodeOrVariable)object)) {
                    log.warn("You just added a statement (" + subject + " " + predicate + " " + object + " ) which could not be stored. Most likely cause: http://openrdf.org/issues/browse/SES-521");
                }
            }
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Iterator<? extends org.ontoware.rdf2go.model.Statement> iterator) throws ModelRuntimeException {
        if (this.isLocked()) {
            throw new ModelRuntimeException("Model is locked, cannot perform an update.");
        }
        this.assertModel();
        try {
            boolean autocommitBefore = this.connection.isAutoCommit();
            this.connection.setAutoCommit(false);
            try {
                try {
                    while (iterator.hasNext()) {
                        Statement s = ConversionUtil.toOpenRDF(iterator.next(), this.valueFactory);
                        this.connection.remove(s, new Resource[]{this.openRdfContext});
                    }
                    this.connection.commit();
                }
                catch (RepositoryException x) {
                    this.connection.rollback();
                }
            }
            finally {
                this.connection.setAutoCommit(autocommitBefore);
            }
        }
        catch (RepositoryException x) {
            throw new ModelRuntimeException((Throwable)x);
        }
    }

    public void removeAll() throws ModelRuntimeException {
        if (this.isLocked()) {
            throw new ModelRuntimeException("Model is locked, cannot perform an update.");
        }
        this.assertModel();
        try {
            boolean autocommitBefore = this.connection.isAutoCommit();
            this.connection.setAutoCommit(false);
            this.connection.clear(new Resource[0]);
            this.connection.setAutoCommit(autocommitBefore);
        }
        catch (RepositoryException x) {
            throw new ModelRuntimeException((Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Iterator<? extends org.ontoware.rdf2go.model.Statement> iterator) throws ModelRuntimeException {
        if (this.isLocked()) {
            throw new ModelRuntimeException("Model is locked, cannot perform an update.");
        }
        this.assertModel();
        try {
            boolean autocommitBefore = this.connection.isAutoCommit();
            this.connection.setAutoCommit(false);
            try {
                try {
                    while (iterator.hasNext()) {
                        Statement s = ConversionUtil.toOpenRDF(iterator.next(), this.valueFactory);
                        this.connection.add(s, new Resource[]{this.openRdfContext});
                    }
                    this.connection.commit();
                }
                catch (RepositoryException x) {
                    this.connection.rollback();
                }
            }
            finally {
                this.connection.setAutoCommit(autocommitBefore);
            }
        }
        catch (RepositoryException x) {
            throw new ModelRuntimeException((Throwable)x);
        }
    }

    public void removeStatement(org.ontoware.rdf2go.model.node.Resource subject, URI predicate, Node object) throws ModelRuntimeException {
        this.assertModel();
        try {
            Resource openRdfSubject = (Resource)ConversionUtil.toOpenRDF(subject, this.valueFactory);
            org.openrdf.model.URI openRdfPredicate = ConversionUtil.toOpenRDF(predicate, this.valueFactory);
            Value openRdfObject = ConversionUtil.toOpenRDF(object, this.valueFactory);
            this.connection.remove(openRdfSubject, openRdfPredicate, openRdfObject, new Resource[]{this.openRdfContext});
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public ClosableIterator<org.ontoware.rdf2go.model.Statement> findStatements(ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        this.assertModel();
        Resource openRdfSubject = (Resource)ConversionUtil.toOpenRDF(subject, this.valueFactory);
        org.openrdf.model.URI openRdfPredicate = (org.openrdf.model.URI)ConversionUtil.toOpenRDF(predicate, this.valueFactory);
        Value openRdfObject = ConversionUtil.toOpenRDF(object, this.valueFactory);
        try {
            RepositoryResult statements = this.connection.getStatements(openRdfSubject, openRdfPredicate, openRdfObject, true, new Resource[]{this.openRdfContext});
            return new StatementIterator((CloseableIteration<? extends Statement, ? extends OpenRDFException>)statements, this);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public boolean sparqlAsk(String query) throws ModelRuntimeException {
        this.assertModel();
        try {
            boolean result = this.connection.prepareBooleanQuery(QueryLanguage.SPARQL, query).evaluate();
            return result;
        }
        catch (MalformedQueryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (UnsupportedQueryLanguageException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public ClosableIterable<org.ontoware.rdf2go.model.Statement> sparqlDescribe(String query) throws ModelRuntimeException {
        this.assertModel();
        try {
            GraphQueryResult graphQueryResult = this.connection.prepareGraphQuery(QueryLanguage.SPARQL, query).evaluate();
            return new GraphIterable(graphQueryResult, this);
        }
        catch (MalformedQueryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (UnsupportedQueryLanguageException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public ClosableIterable<org.ontoware.rdf2go.model.Statement> sparqlConstruct(String query) throws ModelRuntimeException {
        this.assertModel();
        try {
            GraphQueryResult graphQueryResult = this.connection.prepareGraphQuery(QueryLanguage.SPARQL, query).evaluate();
            return new GraphIterable(graphQueryResult, this);
        }
        catch (MalformedQueryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (UnsupportedQueryLanguageException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public QueryResultTable sparqlSelect(String queryString) throws ModelRuntimeException {
        this.assertModel();
        return new RepositoryQueryResultTable(queryString, this.connection);
    }

    public ClosableIterator<org.ontoware.rdf2go.model.Statement> iterator() {
        this.assertModel();
        try {
            RepositoryResult statements = this.connection.getStatements(null, null, null, true, new Resource[]{this.openRdfContext});
            return new StatementIterator((CloseableIteration<? extends Statement, ? extends OpenRDFException>)statements, this);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public Object getUnderlyingModelImplementation() {
        return this.repository;
    }

    public void setUnderlyingModelImplementation(Object object) {
        this.repository = (Repository)object;
    }

    public long size() throws ModelRuntimeException {
        this.assertModel();
        try {
            return this.connection.size(new Resource[]{this.openRdfContext});
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public URI getContextURI() {
        if (this.context.toString().equals(DEFAULT_CONTEXT)) {
            return null;
        }
        return this.context;
    }

    public synchronized boolean isLocked() {
        return this.locked;
    }

    public synchronized void lock() throws LockException {
        if (this.isLocked()) {
            return;
        }
        try {
            this.locked = true;
            this.autocommitBeforeLock = this.connection.isAutoCommit();
            this.connection.setAutoCommit(false);
            this.connection.commit();
        }
        catch (RepositoryException e) {
            throw new LockException((Exception)((Object)e));
        }
    }

    public synchronized void unlock() {
        if (!this.isLocked()) {
            return;
        }
        try {
            this.connection.commit();
            this.connection.setAutoCommit(this.autocommitBeforeLock);
            this.locked = false;
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public synchronized void rollback() {
        if (!this.isLocked()) {
            return;
        }
        this.assertModel();
        try {
            this.connection.rollback();
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void dump() {
        this.assertModel();
        ClosableIterator<org.ontoware.rdf2go.model.Statement> iterator = this.iterator();
        System.out.println("Dumping Repository contents ----------------------------------------------");
        while (iterator.hasNext()) {
            ((org.ontoware.rdf2go.model.Statement)iterator.next()).dump(null);
        }
    }

    public void readFrom(InputStream stream) throws IOException, ModelRuntimeException {
        this.readFrom(stream, RDFFormat.RDFXML, "");
    }

    public void readFrom(InputStream stream, Syntax syntax) throws IOException, ModelRuntimeException {
        RDFFormat format = RDFFormat.forMIMEType((String)syntax.getMimeType());
        if (format == null) {
            throw new ModelRuntimeException("unknown syntax: " + syntax);
        }
        this.readFrom(stream, format, "");
    }

    public void readFrom(InputStream stream, Syntax syntax, String baseURI) throws IOException, ModelRuntimeException {
        RDFFormat format = RDFFormat.forMIMEType((String)syntax.getMimeType());
        if (format == null) {
            throw new ModelRuntimeException("unknown syntax: " + syntax);
        }
        this.readFrom(stream, format, baseURI);
    }

    public void readFrom(Reader reader, Syntax syntax, String baseURI) throws ModelRuntimeException, IOException {
        RDFFormat format = RDFFormat.forMIMEType((String)syntax.getMimeType());
        if (format == null) {
            throw new ModelRuntimeException("unknown syntax: " + syntax);
        }
        this.readFrom(reader, format, baseURI);
    }

    public void readFrom(InputStream stream, RDFFormat format, String baseURI) throws IOException, ModelRuntimeException {
        this.assertModel();
        try {
            this.connection.add(stream, baseURI, format, new Resource[]{this.openRdfContext});
        }
        catch (RDFParseException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void readFrom(Reader reader) throws IOException, ModelRuntimeException {
        this.readFrom(reader, RDFFormat.RDFXML, "");
    }

    public void readFrom(Reader reader, Syntax syntax) throws IOException, ModelRuntimeException {
        RDFFormat format = RDFFormat.forMIMEType((String)syntax.getMimeType());
        if (format == null) {
            throw new ModelRuntimeException("unknown syntax: " + format);
        }
        this.readFrom(reader, format, "");
    }

    public void readFrom(Reader reader, RDFFormat format, String baseURL) throws IOException, ModelRuntimeException {
        this.assertModel();
        try {
            this.connection.add(reader, baseURL, format, new Resource[]{this.openRdfContext});
        }
        catch (RDFParseException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void writeTo(OutputStream stream) throws IOException, ModelRuntimeException {
        this.writeTo(stream, Syntax.RdfXml);
    }

    public void writeTo(OutputStream stream, Syntax syntax) throws IOException, ModelRuntimeException {
        RDFWriter rdfWriter = Rio.createWriter((RDFFormat)RepositoryModel.getRDFFormat(syntax), (OutputStream)stream);
        this.writeTo(rdfWriter);
    }

    public void writeTo(Writer writer) throws ModelRuntimeException {
        this.writeTo(writer, Syntax.RdfXml);
    }

    public void writeTo(Writer writer, Syntax syntax) throws ModelRuntimeException {
        this.assertModel();
        RDFWriter rdfWriter = Rio.createWriter((RDFFormat)RepositoryModel.getRDFFormat(syntax), (Writer)writer);
        this.writeTo(rdfWriter);
    }

    public static RDFFormat getRDFFormat(Syntax syntax) throws ModelRuntimeException {
        String mimeType = syntax.getMimeType();
        return RDFFormat.forMIMEType((String)mimeType);
    }

    public void writeTo(RDFWriter writer) throws ModelRuntimeException {
        this.assertModel();
        try {
            this.connection.exportStatements(null, null, null, false, (RDFHandler)writer, new Resource[]{this.openRdfContext});
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (RDFHandlerException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void commit() {
        try {
            this.connection.commit();
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void setAutocommit(boolean autocommit) {
        this.assertModel();
        try {
            this.connection.setAutoCommit(autocommit);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            if (this.connection.isOpen()) {
                if (this.caller != null) {
                    StringWriter sw = new StringWriter();
                    this.caller.printStackTrace(new PrintWriter(sw));
                    this.logger.warn(((Object)((Object)this)).getClass().getName() + " not closed, closing now. Cause " + sw.getBuffer().toString());
                } else {
                    this.logger.warn(((Object)((Object)this)).getClass().getName() + " not closed, closing now.");
                }
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void assertModel() {
        if (this.repository == null) {
            throw new ModelRuntimeException("Repository is null");
        }
        if (this.connection == null) {
            throw new ModelRuntimeException("Connection is null");
        }
    }

    public boolean isIsomorphicWith(Model other) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public void update(Diff diff) throws ModelRuntimeException {
        this.update((DiffReader)diff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(DiffReader diff) throws ModelRuntimeException {
        if (this.isLocked()) {
            throw new ModelRuntimeException("Model is locked, cannot perform an update.");
        }
        this.assertModel();
        try {
            boolean autocommitBefore = this.connection.isAutoCommit();
            this.connection.setAutoCommit(false);
            try {
                try {
                    Statement s;
                    Iterator it = diff.getRemoved().iterator();
                    while (it.hasNext()) {
                        s = ConversionUtil.toOpenRDF((org.ontoware.rdf2go.model.Statement)it.next(), this.valueFactory);
                        this.connection.remove(s, new Resource[]{this.openRdfContext});
                    }
                    it = diff.getAdded().iterator();
                    while (it.hasNext()) {
                        s = ConversionUtil.toOpenRDF((org.ontoware.rdf2go.model.Statement)it.next(), this.valueFactory);
                        this.connection.add(s, new Resource[]{this.openRdfContext});
                    }
                    this.connection.commit();
                }
                catch (RepositoryException x) {
                    this.logger.warn("Could not commit, rolling back.", (Throwable)x);
                    this.connection.rollback();
                }
            }
            finally {
                this.connection.setAutoCommit(autocommitBefore);
            }
        }
        catch (RepositoryException x) {
            throw new ModelRuntimeException((Throwable)x);
        }
    }

    public String getNamespace(String prefix) {
        this.assertModel();
        try {
            return this.connection.getNamespace(prefix);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public Map<String, String> getNamespaces() {
        this.assertModel();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        try {
            RepositoryResult openrdfMap = this.connection.getNamespaces();
            openrdfMap.enableDuplicateFilter();
            List openrdfList = openrdfMap.asList();
            for (Namespace openrdfNamespace : openrdfList) {
                nsMap.put(openrdfNamespace.getPrefix(), openrdfNamespace.getName());
            }
            return nsMap;
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void removeNamespace(String prefix) {
        this.assertModel();
        try {
            this.connection.removeNamespace(prefix);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void setNamespace(String prefix, String namespaceURI) throws IllegalArgumentException {
        this.assertModel();
        try {
            this.connection.setNamespace(prefix, namespaceURI);
        }
        catch (RepositoryException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }
}

