/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import org.simpleframework.http.RequestHeader;
import org.simpleframework.http.ResponseHeader;

public class Conversation {
    private final ResponseHeader response;
    private final RequestHeader request;

    public Conversation(RequestHeader request, ResponseHeader response) {
        this.response = response;
        this.request = request;
    }

    public RequestHeader getRequest() {
        return this.request;
    }

    public ResponseHeader getResponse() {
        return this.response;
    }

    public long getContentLength() {
        return this.response.getContentLength();
    }

    public boolean isEmpty() {
        int code = this.response.getCode();
        if (code == 204) {
            return true;
        }
        return code == 304;
    }

    public boolean isHead() {
        String method = this.request.getMethod();
        if (method != null) {
            return method.equalsIgnoreCase("HEAD");
        }
        return false;
    }

    public boolean isConnect() {
        String method = this.request.getMethod();
        if (method != null) {
            return method.equalsIgnoreCase("CONNECT");
        }
        return false;
    }

    public void setContentLength(long length) {
        boolean keepAlive = this.isKeepAlive();
        if (keepAlive) {
            this.response.setValue("Connection", "keep-alive");
        } else {
            this.response.setValue("Connection", "close");
        }
        this.response.setLong("Content-Length", length);
    }

    public boolean isPersistent() {
        String token = this.request.getValue("Connection");
        if (token != null) {
            return token.equalsIgnoreCase("keep-alive");
        }
        int major = this.request.getMajor();
        int minor = this.request.getMinor();
        if (major > 1) {
            return true;
        }
        if (major == 1) {
            return minor > 0;
        }
        return false;
    }

    public boolean isKeepAlive() {
        String token = this.response.getValue("Connection");
        if (token != null) {
            return !token.equalsIgnoreCase("close");
        }
        return this.isPersistent();
    }

    public boolean isChunkable() {
        int major = this.request.getMajor();
        int minor = this.request.getMinor();
        if (major >= 1) {
            return minor >= 1;
        }
        return false;
    }

    public void setChunkedEncoded() {
        boolean keepAlive = this.isKeepAlive();
        boolean chunkable = this.isChunkable();
        if (keepAlive && chunkable) {
            this.response.setValue("Transfer-Encoding", "chunked");
            this.response.setValue("Connection", "keep-alive");
        } else {
            this.response.setValue("Connection", "close");
        }
    }

    public void setConnectionUpgrade() {
        this.response.setValue("Transfer-Encoding", null);
        this.response.setValue("Content-Length", null);
        this.response.setValue("Connection", "Upgrade");
    }

    public void setIdentityEncoded() {
        this.response.setValue("Transfer-Encoding", null);
    }

    public boolean isChunkedEncoded() {
        String token = this.response.getValue("Transfer-Encoding");
        if (token != null) {
            return token.equalsIgnoreCase("chunked");
        }
        return false;
    }

    public boolean isWebSocket() {
        String token = this.request.getValue("Upgrade");
        int code = this.response.getCode();
        if (token != null && code == 101) {
            String reply = this.response.getValue("Upgrade");
            if (token.equalsIgnoreCase("websocket")) {
                return token.equalsIgnoreCase(reply);
            }
        }
        return false;
    }

    public boolean isTunnel() {
        boolean socket = this.isWebSocket();
        if (!socket) {
            int code = this.response.getCode();
            if (code < 200) {
                return false;
            }
            if (code >= 300) {
                return false;
            }
            return this.isConnect();
        }
        return true;
    }
}

