/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.simpleframework.common.buffer.Buffer;
import org.simpleframework.http.Part;
import org.simpleframework.http.message.Body;
import org.simpleframework.http.message.EmptyInputStream;
import org.simpleframework.http.message.PartSeries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BufferBody
implements Body {
    private final PartSeries series;
    private final Buffer buffer;

    public BufferBody() {
        this(null);
    }

    public BufferBody(Buffer buffer) {
        this(buffer, null);
    }

    public BufferBody(Buffer buffer, PartSeries series) {
        this.buffer = buffer;
        this.series = series;
    }

    @Override
    public Part getPart(String name) {
        if (this.series != null) {
            return this.series.getPart(name);
        }
        return null;
    }

    @Override
    public List<Part> getParts() {
        if (this.series != null) {
            return this.series.getParts();
        }
        return Collections.emptyList();
    }

    @Override
    public String getContent() throws IOException {
        if (this.buffer == null) {
            return new String();
        }
        return this.buffer.encode();
    }

    @Override
    public String getContent(String charset) throws IOException {
        if (this.buffer == null) {
            return new String();
        }
        return this.buffer.encode(charset);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.buffer == null) {
            return new EmptyInputStream();
        }
        return this.buffer.open();
    }
}

