/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.socket.service.Router;
import org.simpleframework.http.socket.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolRouter
implements Router {
    private final Map<String, Service> registry;
    private final Service primary;

    public ProtocolRouter(Map<String, Service> registry, Service primary) throws IOException {
        this.registry = registry;
        this.primary = primary;
    }

    @Override
    public Service route(Request request, Response response) {
        String token = request.getValue("Upgrade");
        if (token != null && token.equalsIgnoreCase("websocket")) {
            List<String> protocols = request.getValues("Sec-WebSocket-Protocol");
            String version = request.getValue("Sec-WebSocket-Version");
            if (version != null) {
                response.setValue("Sec-WebSocket-Version", version);
            }
            for (String protocol : protocols) {
                Service service = this.registry.get(protocol);
                if (service == null) continue;
                response.setValue("Sec-WebSocket-Protocol", protocol);
                return service;
            }
            return this.primary;
        }
        return null;
    }
}

