/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.util.List;
import org.simpleframework.http.Request;

class RequestValidator {
    private final Request request;
    private final String version;

    public RequestValidator(Request request) {
        this(request, "13");
    }

    public RequestValidator(Request request, String version) {
        this.request = request;
        this.version = version;
    }

    public boolean isValid() {
        if (!this.isProtocol()) {
            return false;
        }
        return this.isUpgrade();
    }

    private boolean isProtocol() {
        String protocol = this.request.getValue("Sec-WebSocket-Version");
        String token = this.request.getValue("Sec-WebSocket-Key");
        if (token != null) {
            return this.version.equals(protocol);
        }
        return false;
    }

    private boolean isUpgrade() {
        List<String> tokens = this.request.getValues("Connection");
        for (String token : tokens) {
            if (!token.equalsIgnoreCase("Upgrade")) continue;
            String upgrade = this.request.getValue("Upgrade");
            if (upgrade != null) {
                return upgrade.equalsIgnoreCase("websocket");
            }
            return false;
        }
        return false;
    }
}

