/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.simpleframework.xml.load.ClassType;
import org.simpleframework.xml.load.ConversionType;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.InstantiationException;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;

class CollectionFactory
extends Factory {
    public CollectionFactory(Source root, Class field) {
        super(root, field);
    }

    public Object getInstance() throws Exception {
        Class type = this.getConversion(this.field);
        if (type != null) {
            return type.newInstance();
        }
        return null;
    }

    public Type getInstance(InputNode node) throws Exception {
        Type type = this.getOverride(node);
        if (type != null) {
            return this.getInstance(type);
        }
        if (!CollectionFactory.isInstantiable(this.field)) {
            this.field = this.getConversion(this.field);
        }
        if (!this.isCollection(this.field)) {
            throw new InstantiationException("Type is not a collection %s", this.field);
        }
        return new ClassType(this.field);
    }

    public Type getInstance(Type type) throws Exception {
        Class real = type.getType();
        if (!CollectionFactory.isInstantiable(real)) {
            real = this.getConversion(real);
        }
        if (!this.isCollection(real)) {
            throw new InstantiationException("Type is not a collection %s", real);
        }
        return new ConversionType(type, real);
    }

    public Class getConversion(Class type) throws Exception {
        if (type.isAssignableFrom(ArrayList.class)) {
            return ArrayList.class;
        }
        if (type.isAssignableFrom(HashSet.class)) {
            return HashSet.class;
        }
        if (type.isAssignableFrom(TreeSet.class)) {
            return TreeSet.class;
        }
        throw new InstantiationException("Cannot instantiate %s", type);
    }

    private boolean isCollection(Class type) {
        return Collection.class.isAssignableFrom(type);
    }
}

